PaintBlack blackPaint;
PaintRed redPaint;
PaintBlue bluePaint;
PaintOrange orangePaint;
PaintWhite whitePaint;

PImage canvas;

void setup() {
  size(1200, 500);
  canvas = loadImage("canvasTexture.jpg");
  blackPaint = new PaintBlack();
  redPaint = new PaintRed();
  bluePaint = new PaintBlue();
  orangePaint = new PaintOrange();
  whitePaint = new PaintWhite();

  background(canvas);
  
  smooth();
}

void draw() {

  blackPaint.display();
  blackPaint.move();
  
  redPaint.display();
  redPaint.move();
  
  bluePaint.display();
  bluePaint.move();
  
  orangePaint.display();
  orangePaint.move();
  
  whitePaint.display();
  whitePaint.move();
  
  //drawTarget(width*0.5, height*0.5, 250, 12);
}

/* void drawTarget(float xloc, float yloc, int size, int num) {
  float grayvalues = 255/num;
  float steps = size/num;
  for (int i = 0; i < num; i++) {
    fill(i*grayvalues);
    ellipse(xloc, yloc, size - i*steps, size - i*steps);
  }
}
*/

// BLACK PAINT //

class PaintBlack {
  float x1, y1, x2, y2;
  int step = 5;
  float noise = 20;


  PaintBlack() {
     x1 = 0;
     y1 = height/2;
     x2 = 0;
     y2 = height/2;
  }
  
  void move(){
   

    if (x2<0) {
      step*=-1;
      x2 = 0;
    }
    else if(x2>width+50) {
      step*=-1;
      x2 = width-50;
    }
      x2+=step;
      
     y2 = y1+ map(noise(noise), 0, 1, -60, 60);
      noise+=0.1;
    y2 = constrain(y2, 0, height); 
  }

    void display() {
      stroke(35);
      strokeWeight(random(5, 7));
      line(x1, y1, x2, y2);

      x1 = x2;
      y1 = y2;
    }
}


// RED PAINT //

class PaintRed {
  float x1, y1, x2, y2;
  int step = 15;
  float noise = 20;


  PaintRed() {
     x1 = 0;
     y1 = height/2;
     x2 = 0;
     y2 = height/2;
  }
  
  void move(){
   

    if (x2<0) {
      step*=-1;
      x2 = 0;
    }
    else if(x2>width+50) {
      step*=-1;
      x2 = width-50;
    }
      x2+=step;
      
     y2 = y1+ map(noise(noise), 0, 1, -60, 60);
      noise+=0.1;
    y2 = constrain(y2, 0, height); 
  }

    void display() {
      stroke(190,0,20);
      strokeWeight(random(18, 20));
      line(x1, y1, x2, y2);

      x1 = x2;
      y1 = y2;
    }
}


// BLUE PAINT //

class PaintBlue {
  float x1, y1, x2, y2;
  int step = 25;
  float noise = 20;


  PaintBlue() {
     x1 = 0;
     y1 = height/2;
     x2 = 0;
     y2 = height/2;
  }
  
  void move(){
   

    if (x2<0) {
      step*=-1;
      x2 = 0;
    }
    else if(x2>width+50) {
      step*=-1;
      x2 = width-50;
    }
      x2+=step;
      
     y2 = y1+ map(noise(noise), 0, 1, -60, 60);
      noise+=0.1;
    y2 = constrain(y2, 0, height); 
  }

    void display() {
      stroke(160,200,255);
      strokeWeight(random(16, 18));
      line(x1, y1, x2, y2);

      x1 = x2;
      y1 = y2;
    }
}


// ORANGE PAINT //

class PaintOrange {
  float x1, y1, x2, y2;
  int step = 20;
  float noise = 20;


  PaintOrange() {
     x1 = 0;
     y1 = height/2;
     x2 = 0;
     y2 = height/2;
  }
  
  void move(){
   

    if (x2<0) {
      step*=-1;
      x2 = 0;
    }
    else if(x2>width+50) {
      step*=-1;
      x2 = width-50;
    }
      x2+=step;
      
     y2 = y1+ map(noise(noise), 0, 1, -40, 40);
      noise+=0.1;
    y2 = constrain(y2, 0, height); 
  }

    void display() {
      stroke(255,120,30);
      strokeWeight(random(18, 20));
      line(x1, y1, x2, y2);

      x1 = x2;
      y1 = y2;
    }
}


// WHITE PAINT //

class PaintWhite {
  float x1, y1, x2, y2;
  int step = 10;
  float noise = 20;


  PaintWhite() {
     x1 = 0;
     y1 = height/2;
     x2 = 0;
     y2 = height/2;
  }
  
  void move(){
   

    if (x2<0) {
      step*=-1;
      x2 = 0;
    }
    else if(x2>width+50) {
      step*=-1;
      x2 = width-50;
    }
      x2+=step;
      
     y2 = y1+ map(noise(noise), 0, 1, -30, 30);
      noise+=0.1;
    y2 = constrain(y2, 0, height); 
  }

    void display() {
      stroke(255);
      strokeWeight(random(8, 10));
      line(x1, y1, x2, y2);

      x1 = x2;
      y1 = y2;
    }
}
