/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PMatrix;
import processing.core.PMatrix2D;
import processing.core.PMatrix3D;
import processing.core.PShape;
import processing.core.PShapeSVG;
import processing.data.XML;

public class PGraphicsJava2D
extends PGraphics {
    public Graphics2D g2;
    protected BufferedImage offscreen;
    GeneralPath gpath;
    boolean breakShape;
    float[] curveCoordX;
    float[] curveCoordY;
    float[] curveDrawX;
    float[] curveDrawY;
    int transformCount;
    AffineTransform[] transformStack = new AffineTransform[32];
    double[] transform = new double[6];
    Line2D.Float line = new Line2D.Float();
    Ellipse2D.Float ellipse = new Ellipse2D.Float();
    Rectangle2D.Float rect = new Rectangle2D.Float();
    Arc2D.Float arc = new Arc2D.Float();
    protected Color tintColorObject;
    protected Color fillColorObject;
    public boolean fillGradient;
    public Paint fillGradientObject;
    protected Color strokeColorObject;
    public boolean strokeGradient;
    public Paint strokeGradientObject;
    int[] clearPixels;
    static int[] getset = new int[1];

    @Override
    public void setSize(int iwidth, int iheight) {
        this.width = iwidth;
        this.height = iheight;
        this.allocate();
        this.reapplySettings();
    }

    @Override
    protected void allocate() {
        if (this.primarySurface) {
            this.parent.updateListeners(this.parent);
            this.image = new BufferedImage(this.width, this.height, 1);
            this.offscreen = new BufferedImage(this.width, this.height, 2);
            this.g2 = (Graphics2D)this.offscreen.getGraphics();
        } else {
            this.image = new BufferedImage(this.width, this.height, 2);
            this.g2 = (Graphics2D)this.image.getGraphics();
        }
    }

    @Override
    public boolean canDraw() {
        return true;
    }

    @Override
    public void requestDraw() {
        this.parent.handleDraw();
    }

    @Override
    public void beginDraw() {
        this.checkSettings();
        this.resetMatrix();
        this.vertexCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endDraw() {
        if (this.primarySurface) {
            if (this.canvas != null) {
                System.out.println(this.canvas);
                this.canvas.repaint();
            } else {
                Image image = this.image;
                synchronized (image) {
                    this.image.getGraphics().drawImage(this.offscreen, 0, 0, null);
                }
            }
        } else {
            this.loadPixels();
        }
        this.setModified();
        super.updatePixels();
    }

    @Override
    public void beginShape(int kind) {
        this.shape = kind;
        this.vertexCount = 0;
        this.curveVertexCount = 0;
        this.gpath = null;
    }

    @Override
    public void texture(PImage image) {
        PGraphicsJava2D.showMethodWarning("texture");
    }

    @Override
    public void vertex(float x, float y) {
        this.curveVertexCount = 0;
        if (this.vertexCount == this.vertices.length) {
            float[][] temp = new float[this.vertexCount << 1][37];
            System.arraycopy(this.vertices, 0, temp, 0, this.vertexCount);
            this.vertices = temp;
        }
        this.vertices[this.vertexCount][0] = x;
        this.vertices[this.vertexCount][1] = y;
        ++this.vertexCount;
        switch (this.shape) {
            case 3: {
                this.point(x, y);
                break;
            }
            case 5: {
                if (this.vertexCount % 2 != 0) break;
                this.line(this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], x, y);
                break;
            }
            case 9: {
                if (this.vertexCount % 3 != 0) break;
                this.triangle(this.vertices[this.vertexCount - 3][0], this.vertices[this.vertexCount - 3][1], this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], x, y);
                break;
            }
            case 10: {
                if (this.vertexCount < 3) break;
                this.triangle(this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], this.vertices[this.vertexCount - 1][0], this.vertices[this.vertexCount - 1][1], this.vertices[this.vertexCount - 3][0], this.vertices[this.vertexCount - 3][1]);
                break;
            }
            case 11: {
                if (this.vertexCount == 3) {
                    this.triangle(this.vertices[0][0], this.vertices[0][1], this.vertices[1][0], this.vertices[1][1], x, y);
                    break;
                }
                if (this.vertexCount <= 3) break;
                this.gpath = new GeneralPath();
                this.gpath.moveTo(this.vertices[0][0], this.vertices[0][1]);
                this.gpath.lineTo(this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1]);
                this.gpath.lineTo(x, y);
                this.drawShape(this.gpath);
                break;
            }
            case 17: {
                if (this.vertexCount % 4 != 0) break;
                this.quad(this.vertices[this.vertexCount - 4][0], this.vertices[this.vertexCount - 4][1], this.vertices[this.vertexCount - 3][0], this.vertices[this.vertexCount - 3][1], this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], x, y);
                break;
            }
            case 18: {
                if (this.vertexCount < 4 || this.vertexCount % 2 != 0) break;
                this.quad(this.vertices[this.vertexCount - 4][0], this.vertices[this.vertexCount - 4][1], this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], x, y, this.vertices[this.vertexCount - 3][0], this.vertices[this.vertexCount - 3][1]);
                break;
            }
            case 20: {
                if (this.gpath == null) {
                    this.gpath = new GeneralPath();
                    this.gpath.moveTo(x, y);
                    break;
                }
                if (this.breakShape) {
                    this.gpath.moveTo(x, y);
                    this.breakShape = false;
                    break;
                }
                this.gpath.lineTo(x, y);
            }
        }
    }

    @Override
    public void vertex(float x, float y, float z) {
        PGraphicsJava2D.showDepthWarningXYZ("vertex");
    }

    @Override
    public void vertex(float[] v) {
        this.vertex(v[0], v[1]);
    }

    @Override
    public void vertex(float x, float y, float u, float v) {
        PGraphicsJava2D.showVariationWarning("vertex(x, y, u, v)");
    }

    @Override
    public void vertex(float x, float y, float z, float u, float v) {
        PGraphicsJava2D.showDepthWarningXYZ("vertex");
    }

    @Override
    public void beginContour() {
        this.breakShape = true;
    }

    @Override
    public void endContour() {
    }

    @Override
    public void endShape(int mode) {
        if (this.gpath != null && this.shape == 20) {
            if (mode == 2) {
                this.gpath.closePath();
            }
            this.drawShape(this.gpath);
        }
        this.shape = 0;
    }

    @Override
    public void bezierVertex(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.bezierVertexCheck();
        this.gpath.curveTo(x1, y1, x2, y2, x3, y3);
    }

    @Override
    public void bezierVertex(float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        PGraphicsJava2D.showDepthWarningXYZ("bezierVertex");
    }

    @Override
    public void quadraticVertex(float ctrlX, float ctrlY, float endX, float endY) {
        this.bezierVertexCheck();
        Point2D cur = this.gpath.getCurrentPoint();
        float x1 = (float)cur.getX();
        float y1 = (float)cur.getY();
        this.bezierVertex(x1 + (ctrlX - x1) * 2.0f / 3.0f, y1 + (ctrlY - y1) * 2.0f / 3.0f, endX + (ctrlX - endX) * 2.0f / 3.0f, endY + (ctrlY - endY) * 2.0f / 3.0f, endX, endY);
    }

    @Override
    public void quadraticVertex(float x2, float y2, float z2, float x4, float y4, float z4) {
        PGraphicsJava2D.showDepthWarningXYZ("quadVertex");
    }

    @Override
    protected void curveVertexCheck() {
        super.curveVertexCheck();
        if (this.curveCoordX == null) {
            this.curveCoordX = new float[4];
            this.curveCoordY = new float[4];
            this.curveDrawX = new float[4];
            this.curveDrawY = new float[4];
        }
    }

    @Override
    protected void curveVertexSegment(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        this.curveCoordX[0] = x1;
        this.curveCoordY[0] = y1;
        this.curveCoordX[1] = x2;
        this.curveCoordY[1] = y2;
        this.curveCoordX[2] = x3;
        this.curveCoordY[2] = y3;
        this.curveCoordX[3] = x4;
        this.curveCoordY[3] = y4;
        this.curveToBezierMatrix.mult(this.curveCoordX, this.curveDrawX);
        this.curveToBezierMatrix.mult(this.curveCoordY, this.curveDrawY);
        if (this.gpath == null) {
            this.gpath = new GeneralPath();
            this.gpath.moveTo(this.curveDrawX[0], this.curveDrawY[0]);
        }
        this.gpath.curveTo(this.curveDrawX[1], this.curveDrawY[1], this.curveDrawX[2], this.curveDrawY[2], this.curveDrawX[3], this.curveDrawY[3]);
    }

    @Override
    public void curveVertex(float x, float y, float z) {
        PGraphicsJava2D.showDepthWarningXYZ("curveVertex");
    }

    @Override
    public void point(float x, float y) {
        if (this.stroke) {
            this.line(x, y, x + 1.0E-4f, y + 1.0E-4f);
        }
    }

    @Override
    public void line(float x1, float y1, float x2, float y2) {
        this.line.setLine(x1, y1, x2, y2);
        this.strokeShape(this.line);
    }

    @Override
    public void triangle(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.gpath = new GeneralPath();
        this.gpath.moveTo(x1, y1);
        this.gpath.lineTo(x2, y2);
        this.gpath.lineTo(x3, y3);
        this.gpath.closePath();
        this.drawShape(this.gpath);
    }

    @Override
    public void quad(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        GeneralPath gp = new GeneralPath();
        gp.moveTo(x1, y1);
        gp.lineTo(x2, y2);
        gp.lineTo(x3, y3);
        gp.lineTo(x4, y4);
        gp.closePath();
        this.drawShape(gp);
    }

    @Override
    protected void rectImpl(float x1, float y1, float x2, float y2) {
        this.rect.setFrame(x1, y1, x2 - x1, y2 - y1);
        this.drawShape(this.rect);
    }

    @Override
    protected void ellipseImpl(float x, float y, float w, float h) {
        this.ellipse.setFrame(x, y, w, h);
        this.drawShape(this.ellipse);
    }

    @Override
    protected void arcImpl(float x, float y, float w, float h, float start, float stop) {
        start = -start * 57.295776f;
        stop = -stop * 57.295776f;
        float sweep = stop - start;
        if (this.fill) {
            this.arc.setArc(x, y, w, h, start, sweep, 2);
            this.fillShape(this.arc);
        }
        if (this.stroke) {
            this.arc.setArc(x, y, w, h, start, sweep, 0);
            this.strokeShape(this.arc);
        }
    }

    protected void fillShape(Shape s) {
        if (this.fillGradient) {
            this.g2.setPaint(this.fillGradientObject);
            this.g2.fill(s);
        } else if (this.fill) {
            this.g2.setColor(this.fillColorObject);
            this.g2.fill(s);
        }
    }

    protected void strokeShape(Shape s) {
        if (this.strokeGradient) {
            this.g2.setPaint(this.strokeGradientObject);
            this.g2.draw(s);
        } else if (this.stroke) {
            this.g2.setColor(this.strokeColorObject);
            this.g2.draw(s);
        }
    }

    protected void drawShape(Shape s) {
        if (this.fillGradient) {
            this.g2.setPaint(this.fillGradientObject);
            this.g2.fill(s);
        } else if (this.fill) {
            this.g2.setColor(this.fillColorObject);
            this.g2.fill(s);
        }
        if (this.strokeGradient) {
            this.g2.setPaint(this.strokeGradientObject);
            this.g2.draw(s);
        } else if (this.stroke) {
            this.g2.setColor(this.strokeColorObject);
            this.g2.draw(s);
        }
    }

    @Override
    public void box(float w, float h, float d) {
        PGraphicsJava2D.showMethodWarning("box");
    }

    @Override
    public void sphere(float r) {
        PGraphicsJava2D.showMethodWarning("sphere");
    }

    @Override
    public void bezierDetail(int detail) {
    }

    @Override
    public void curveDetail(int detail) {
    }

    @Override
    public void smooth() {
        this.smooth = true;
        if (this.quality == 0) {
            this.quality = 4;
        }
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.quality == 4 ? RenderingHints.VALUE_INTERPOLATION_BICUBIC : RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    }

    @Override
    public void smooth(int antialias) {
        this.quality = antialias;
        if (antialias == 0) {
            this.noSmooth();
        } else {
            this.smooth();
        }
    }

    @Override
    public void noSmooth() {
        this.smooth = false;
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
    }

    @Override
    protected void imageImpl(PImage who, float x1, float y1, float x2, float y2, int u1, int v1, int u2, int v2) {
        if (who.width <= 0 || who.height <= 0) {
            return;
        }
        if (who.getCache(this) == null) {
            who.setCache(this, new ImageCache(who));
            who.updatePixels();
            who.modified = true;
        }
        ImageCache cash = (ImageCache)who.getCache(this);
        if (this.tint && !cash.tinted || this.tint && cash.tintedColor != this.tintColor || !this.tint && cash.tinted) {
            who.updatePixels();
        }
        if (who.modified) {
            cash.update(this.tint, this.tintColor);
            who.modified = false;
        }
        this.g2.drawImage(((ImageCache)who.getCache((PGraphics)this)).image, (int)x1, (int)y1, (int)x2, (int)y2, u1, v1, u2, v2, null);
    }

    @Override
    public PShape loadShape(String filename) {
        String extension = PApplet.getExtension(filename);
        PShapeSVG svg = null;
        if (extension.equals("svg")) {
            svg = new PShapeSVG(this.parent, filename);
        } else if (extension.equals("svgz")) {
            try {
                GZIPInputStream input = new GZIPInputStream(this.parent.createInput(filename));
                XML xml = new XML(PApplet.createReader(input));
                svg = new PShapeSVG(xml);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            PGraphics.showWarning("Unsupported format");
        }
        return svg;
    }

    @Override
    public float textAscent() {
        Font font;
        if (this.textFont == null) {
            this.defaultFontOrDeath("textAscent");
        }
        if ((font = this.textFont.getFont()) != null) {
            FontMetrics metrics = this.parent.getFontMetrics(font);
            return metrics.getAscent();
        }
        return super.textAscent();
    }

    @Override
    public float textDescent() {
        Font font;
        if (this.textFont == null) {
            this.defaultFontOrDeath("textAscent");
        }
        if ((font = this.textFont.getFont()) != null) {
            FontMetrics metrics = this.parent.getFontMetrics(font);
            return metrics.getDescent();
        }
        return super.textDescent();
    }

    @Override
    protected boolean textModeCheck(int mode) {
        return mode == 4;
    }

    @Override
    public void textSize(float size) {
        Font font;
        if (this.textFont == null) {
            this.defaultFontOrDeath("textAscent", size);
        }
        if ((font = this.textFont.getFont()) != null) {
            Font dfont = font.deriveFont(size);
            this.g2.setFont(dfont);
            this.textFont.setFont(dfont);
        }
        super.textSize(size);
    }

    @Override
    protected float textWidthImpl(char[] buffer, int start, int stop) {
        Font font = this.textFont.getFont();
        if (font != null) {
            int length = stop - start;
            FontMetrics metrics = this.g2.getFontMetrics(font);
            return metrics.charsWidth(buffer, start, length);
        }
        return super.textWidthImpl(buffer, start, stop);
    }

    protected void beginTextScreenMode() {
        this.loadPixels();
    }

    protected void endTextScreenMode() {
        this.updatePixels();
    }

    @Override
    protected void textLineImpl(char[] buffer, int start, int stop, float x, float y) {
        Font font = this.textFont.getFont();
        if (font != null) {
            Object antialias = this.g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            if (antialias == null) {
                antialias = RenderingHints.VALUE_ANTIALIAS_DEFAULT;
            }
            this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.textFont.smooth ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
            this.g2.setColor(this.fillColorObject);
            int length = stop - start;
            this.g2.drawChars(buffer, start, length, (int)(x + 0.5f), (int)(y + 0.5f));
            this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialias);
        } else {
            super.textLineImpl(buffer, start, stop, x, y);
        }
    }

    @Override
    public void pushMatrix() {
        if (this.transformCount == this.transformStack.length) {
            throw new RuntimeException("pushMatrix() cannot use push more than " + this.transformStack.length + " times");
        }
        this.transformStack[this.transformCount] = this.g2.getTransform();
        ++this.transformCount;
    }

    @Override
    public void popMatrix() {
        if (this.transformCount == 0) {
            throw new RuntimeException("missing a pushMatrix() to go with that popMatrix()");
        }
        --this.transformCount;
        this.g2.setTransform(this.transformStack[this.transformCount]);
    }

    @Override
    public void translate(float tx, float ty) {
        this.g2.translate(tx, ty);
    }

    @Override
    public void rotate(float angle) {
        this.g2.rotate(angle);
    }

    @Override
    public void rotateX(float angle) {
        PGraphicsJava2D.showDepthWarning("rotateX");
    }

    @Override
    public void rotateY(float angle) {
        PGraphicsJava2D.showDepthWarning("rotateY");
    }

    @Override
    public void rotateZ(float angle) {
        PGraphicsJava2D.showDepthWarning("rotateZ");
    }

    @Override
    public void rotate(float angle, float vx, float vy, float vz) {
        PGraphicsJava2D.showVariationWarning("rotate");
    }

    @Override
    public void scale(float s) {
        this.g2.scale(s, s);
    }

    @Override
    public void scale(float sx, float sy) {
        this.g2.scale(sx, sy);
    }

    @Override
    public void scale(float sx, float sy, float sz) {
        PGraphicsJava2D.showDepthWarningXYZ("scale");
    }

    @Override
    public void shearX(float angle) {
        this.g2.shear(Math.tan(angle), 0.0);
    }

    @Override
    public void shearY(float angle) {
        this.g2.shear(0.0, Math.tan(angle));
    }

    @Override
    public void resetMatrix() {
        this.g2.setTransform(new AffineTransform());
    }

    @Override
    public void applyMatrix(float n00, float n01, float n02, float n10, float n11, float n12) {
        this.g2.transform(new AffineTransform(n00, n10, n01, n11, n02, n12));
    }

    @Override
    public void applyMatrix(float n00, float n01, float n02, float n03, float n10, float n11, float n12, float n13, float n20, float n21, float n22, float n23, float n30, float n31, float n32, float n33) {
        PGraphicsJava2D.showVariationWarning("applyMatrix");
    }

    @Override
    public PMatrix getMatrix() {
        return this.getMatrix((PMatrix2D)null);
    }

    @Override
    public PMatrix2D getMatrix(PMatrix2D target) {
        if (target == null) {
            target = new PMatrix2D();
        }
        this.g2.getTransform().getMatrix(this.transform);
        target.set((float)this.transform[0], (float)this.transform[2], (float)this.transform[4], (float)this.transform[1], (float)this.transform[3], (float)this.transform[5]);
        return target;
    }

    @Override
    public PMatrix3D getMatrix(PMatrix3D target) {
        PGraphicsJava2D.showVariationWarning("getMatrix");
        return target;
    }

    @Override
    public void setMatrix(PMatrix2D source) {
        this.g2.setTransform(new AffineTransform(source.m00, source.m10, source.m01, source.m11, source.m02, source.m12));
    }

    @Override
    public void setMatrix(PMatrix3D source) {
        PGraphicsJava2D.showVariationWarning("setMatrix");
    }

    @Override
    public void printMatrix() {
        this.getMatrix((PMatrix2D)null).print();
    }

    @Override
    public float screenX(float x, float y) {
        this.g2.getTransform().getMatrix(this.transform);
        return (float)this.transform[0] * x + (float)this.transform[2] * y + (float)this.transform[4];
    }

    @Override
    public float screenY(float x, float y) {
        this.g2.getTransform().getMatrix(this.transform);
        return (float)this.transform[1] * x + (float)this.transform[3] * y + (float)this.transform[5];
    }

    @Override
    public float screenX(float x, float y, float z) {
        PGraphicsJava2D.showDepthWarningXYZ("screenX");
        return 0.0f;
    }

    @Override
    public float screenY(float x, float y, float z) {
        PGraphicsJava2D.showDepthWarningXYZ("screenY");
        return 0.0f;
    }

    @Override
    public float screenZ(float x, float y, float z) {
        PGraphicsJava2D.showDepthWarningXYZ("screenZ");
        return 0.0f;
    }

    @Override
    public void strokeCap(int cap) {
        super.strokeCap(cap);
        this.strokeImpl();
    }

    @Override
    public void strokeJoin(int join) {
        super.strokeJoin(join);
        this.strokeImpl();
    }

    @Override
    public void strokeWeight(float weight) {
        super.strokeWeight(weight);
        this.strokeImpl();
    }

    protected void strokeImpl() {
        int cap = 0;
        if (this.strokeCap == 2) {
            cap = 1;
        } else if (this.strokeCap == 4) {
            cap = 2;
        }
        int join = 2;
        if (this.strokeJoin == 8) {
            join = 0;
        } else if (this.strokeJoin == 2) {
            join = 1;
        }
        this.g2.setStroke(new BasicStroke(this.strokeWeight, cap, join));
    }

    @Override
    protected void strokeFromCalc() {
        super.strokeFromCalc();
        this.strokeColorObject = new Color(this.strokeColor, true);
        this.strokeGradient = false;
    }

    @Override
    protected void tintFromCalc() {
        super.tintFromCalc();
        this.tintColorObject = new Color(this.tintColor, true);
    }

    @Override
    protected void fillFromCalc() {
        super.fillFromCalc();
        this.fillColorObject = new Color(this.fillColor, true);
        this.fillGradient = false;
    }

    @Override
    public void backgroundImpl() {
        if (this.backgroundAlpha) {
            WritableRaster raster = ((BufferedImage)this.image).getRaster();
            if (this.clearPixels == null || this.clearPixels.length < this.width) {
                this.clearPixels = new int[this.width];
            }
            Arrays.fill(this.clearPixels, this.backgroundColor);
            int i = 0;
            while (i < this.height) {
                raster.setDataElements(0, i, this.width, 1, this.clearPixels);
                ++i;
            }
        } else {
            Color bgColor = new Color(this.backgroundColor);
            this.pushMatrix();
            this.resetMatrix();
            this.g2.setColor(bgColor);
            this.g2.fillRect(0, 0, this.width, this.height);
            this.popMatrix();
        }
    }

    @Override
    public void beginRaw(PGraphics recorderRaw) {
        PGraphicsJava2D.showMethodWarning("beginRaw");
    }

    @Override
    public void endRaw() {
        PGraphicsJava2D.showMethodWarning("endRaw");
    }

    @Override
    public void loadPixels() {
        if (this.pixels == null || this.pixels.length != this.width * this.height) {
            this.pixels = new int[this.width * this.height];
        }
        WritableRaster raster = ((BufferedImage)(this.primarySurface ? this.offscreen : this.image)).getRaster();
        raster.getDataElements(0, 0, this.width, this.height, this.pixels);
    }

    @Override
    public void updatePixels() {
        WritableRaster raster = ((BufferedImage)(this.primarySurface ? this.offscreen : this.image)).getRaster();
        raster.setDataElements(0, 0, this.width, this.height, this.pixels);
    }

    @Override
    public void updatePixels(int x, int y, int c, int d) {
        if (x != 0 || y != 0 || c != this.width || d != this.height) {
            PGraphicsJava2D.showVariationWarning("updatePixels(x, y, w, h)");
        }
        this.updatePixels();
    }

    @Override
    public int get(int x, int y) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            return 0;
        }
        WritableRaster raster = ((BufferedImage)(this.primarySurface ? this.offscreen : this.image)).getRaster();
        raster.getDataElements(x, y, getset);
        return getset[0];
    }

    @Override
    public PImage getImpl(int x, int y, int w, int h) {
        PImage output = new PImage(w, h);
        output.parent = this.parent;
        WritableRaster raster = ((BufferedImage)(this.primarySurface ? this.offscreen : this.image)).getRaster();
        raster.getDataElements(x, y, w, h, output.pixels);
        return output;
    }

    @Override
    public PImage get() {
        return this.get(0, 0, this.width, this.height);
    }

    @Override
    public void set(int x, int y, int argb) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            return;
        }
        PGraphicsJava2D.getset[0] = argb;
        WritableRaster raster = ((BufferedImage)(this.primarySurface ? this.offscreen : this.image)).getRaster();
        raster.setDataElements(x, y, getset);
    }

    @Override
    protected void setImpl(int dx, int dy, int sx, int sy, int sw, int sh, PImage src) {
        WritableRaster raster = ((BufferedImage)(this.primarySurface ? this.offscreen : this.image)).getRaster();
        if (sx == 0 && sy == 0 && sw == src.width && sh == src.height) {
            raster.setDataElements(dx, dy, src.width, src.height, src.pixels);
        } else {
            PImage temp = src.get(sx, sy, sw, sh);
            raster.setDataElements(dx, dy, temp.width, temp.height, temp.pixels);
        }
    }

    @Override
    public void mask(int[] alpha) {
        PGraphicsJava2D.showMethodWarning("mask");
    }

    @Override
    public void mask(PImage alpha) {
        PGraphicsJava2D.showMethodWarning("mask");
    }

    @Override
    public void copy(int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh) {
        if (sw != dw || sh != dh) {
            this.g2.drawImage(this.image, dx, dy, dx + dw, dy + dh, sx, sy, sx + sw, sy + sh, null);
        } else {
            this.g2.copyArea(sx, sy, sw, sh, dx -= sx, dy -= sy);
        }
    }

    @Override
    public void copy(PImage src, int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh) {
        this.g2.drawImage(src.getImage(), dx, dy, dx + dw, dy + dh, sx, sy, sx + sw, sy + sh, null);
    }

    class ImageCache {
        PImage source;
        boolean tinted;
        int tintedColor;
        int[] tintedPixels;
        BufferedImage image;

        public ImageCache(PImage source) {
            this.source = source;
        }

        public void delete() {
        }

        public void update(boolean tint, int tintColor) {
            boolean wrongType;
            boolean opaque;
            int bufferType = 2;
            boolean bl = opaque = (tintColor & 0xFF000000) == -16777216;
            if (this.source.format == 1 && (!tint || tint && opaque)) {
                bufferType = 1;
            }
            boolean bl2 = wrongType = this.image != null && this.image.getType() != bufferType;
            if (this.image == null || wrongType) {
                this.image = new BufferedImage(this.source.width, this.source.height, bufferType);
            }
            WritableRaster wr = this.image.getRaster();
            if (tint) {
                if (this.tintedPixels == null || this.tintedPixels.length != this.source.width) {
                    this.tintedPixels = new int[this.source.width];
                }
                int a2 = tintColor >> 24 & 0xFF;
                int r2 = tintColor >> 16 & 0xFF;
                int g2 = tintColor >> 8 & 0xFF;
                int b2 = tintColor & 0xFF;
                if (bufferType == 1) {
                    int index = 0;
                    int y = 0;
                    while (y < this.source.height) {
                        int x = 0;
                        while (x < this.source.width) {
                            int argb1 = this.source.pixels[index++];
                            int r1 = argb1 >> 16 & 0xFF;
                            int g1 = argb1 >> 8 & 0xFF;
                            int b1 = argb1 & 0xFF;
                            this.tintedPixels[x] = (r2 * r1 & 0xFF00) << 8 | g2 * g1 & 0xFF00 | (b2 * b1 & 0xFF00) >> 8;
                            ++x;
                        }
                        wr.setDataElements(0, y, this.source.width, 1, this.tintedPixels);
                        ++y;
                    }
                } else if (bufferType == 2) {
                    if (this.source.format == 1 && (tintColor & 0xFFFFFF) == 0xFFFFFF) {
                        int hi = tintColor & 0xFF000000;
                        int index = 0;
                        int y = 0;
                        while (y < this.source.height) {
                            int x = 0;
                            while (x < this.source.width) {
                                this.tintedPixels[x] = hi | this.source.pixels[index++] & 0xFFFFFF;
                                ++x;
                            }
                            wr.setDataElements(0, y, this.source.width, 1, this.tintedPixels);
                            ++y;
                        }
                    } else {
                        int index = 0;
                        int y = 0;
                        while (y < this.source.height) {
                            int a1;
                            int b1;
                            int g1;
                            int r1;
                            int x;
                            if (this.source.format == 1) {
                                int alpha = tintColor & 0xFF000000;
                                x = 0;
                                while (x < this.source.width) {
                                    int argb1 = this.source.pixels[index++];
                                    r1 = argb1 >> 16 & 0xFF;
                                    g1 = argb1 >> 8 & 0xFF;
                                    b1 = argb1 & 0xFF;
                                    this.tintedPixels[x] = alpha | (r2 * r1 & 0xFF00) << 8 | g2 * g1 & 0xFF00 | (b2 * b1 & 0xFF00) >> 8;
                                    ++x;
                                }
                            } else if (this.source.format == 2) {
                                int x2 = 0;
                                while (x2 < this.source.width) {
                                    int argb1 = this.source.pixels[index++];
                                    a1 = argb1 >> 24 & 0xFF;
                                    r1 = argb1 >> 16 & 0xFF;
                                    g1 = argb1 >> 8 & 0xFF;
                                    b1 = argb1 & 0xFF;
                                    this.tintedPixels[x2] = (a2 * a1 & 0xFF00) << 16 | (r2 * r1 & 0xFF00) << 8 | g2 * g1 & 0xFF00 | (b2 * b1 & 0xFF00) >> 8;
                                    ++x2;
                                }
                            } else if (this.source.format == 4) {
                                int lower = tintColor & 0xFFFFFF;
                                x = 0;
                                while (x < this.source.width) {
                                    a1 = this.source.pixels[index++];
                                    this.tintedPixels[x] = (a2 * a1 & 0xFF00) << 16 | lower;
                                    ++x;
                                }
                            }
                            wr.setDataElements(0, y, this.source.width, 1, this.tintedPixels);
                            ++y;
                        }
                    }
                }
            } else {
                wr.setDataElements(0, 0, this.source.width, this.source.height, this.source.pixels);
            }
            this.tinted = tint;
            this.tintedColor = tintColor;
        }
    }
}

