/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import java.util.Arrays;
import java.util.HashMap;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PFont;
import processing.core.PImage;
import processing.opengl.PGL;
import processing.opengl.PGraphicsOpenGL;
import processing.opengl.Texture;

class PFontTexture
implements PConstants {
    protected PApplet parent;
    protected PGraphicsOpenGL pg;
    protected PGL pgl;
    protected PFont font;
    protected boolean is3D;
    protected int maxTexWidth;
    protected int maxTexHeight;
    protected int offsetX;
    protected int offsetY;
    protected int lineHeight;
    protected Texture[] textures = null;
    protected PImage[] images = null;
    protected int currentTex;
    protected int lastTex;
    protected TextureInfo[] glyphTexinfos;
    protected HashMap<PFont.Glyph, TextureInfo> texinfoMap;

    public PFontTexture(PApplet parent, PFont font, int maxw, int maxh, boolean is3D) {
        this.parent = parent;
        this.font = font;
        this.pg = (PGraphicsOpenGL)parent.g;
        this.pgl = this.pg.pgl;
        this.is3D = is3D;
        this.initTexture(maxw, maxh);
    }

    protected void allocate() {
    }

    protected void initTexture(int w, int h) {
        this.maxTexWidth = w;
        this.maxTexHeight = h;
        this.currentTex = -1;
        this.lastTex = -1;
        this.addTexture();
        this.offsetX = 0;
        this.offsetY = 0;
        this.lineHeight = 0;
        this.texinfoMap = new HashMap();
        this.glyphTexinfos = new TextureInfo[this.font.getGlyphCount()];
        this.addAllGlyphsToTexture();
    }

    public boolean addTexture() {
        boolean resize;
        int h;
        int w = this.maxTexWidth;
        if (-1 < this.currentTex && this.textures[this.currentTex].glHeight < this.maxTexHeight) {
            h = PApplet.min(2 * this.textures[this.currentTex].glHeight, this.maxTexHeight);
            resize = true;
        } else {
            h = PApplet.min(PGraphicsOpenGL.maxTextureSize, 512, this.maxTexHeight / 4);
            resize = false;
        }
        Texture tex = this.is3D ? new Texture(this.parent, w, h, new Texture.Parameters(2, 4, false)) : new Texture(this.parent, w, h, new Texture.Parameters(2, 3, false));
        if (this.textures == null) {
            this.textures = new Texture[1];
            this.textures[0] = tex;
            this.images = new PImage[1];
            this.images[0] = this.pg.wrapTexture(tex);
            this.currentTex = 0;
        } else if (resize) {
            Texture tex0 = this.textures[this.currentTex];
            tex.put(tex0);
            this.textures[this.currentTex] = tex;
            this.images[this.currentTex].setCache(this.pg, tex);
            this.images[this.currentTex].width = tex.width;
            this.images[this.currentTex].height = tex.height;
        } else {
            Texture[] tempTex = this.textures;
            this.textures = new Texture[this.textures.length + 1];
            PApplet.arrayCopy(tempTex, this.textures, tempTex.length);
            this.textures[tempTex.length] = tex;
            this.currentTex = this.textures.length - 1;
            PImage[] tempImg = this.images;
            this.images = new PImage[this.textures.length + 1];
            PApplet.arrayCopy(tempImg, this.images, tempImg.length);
            this.images[tempImg.length] = this.pg.wrapTexture(tex);
        }
        this.lastTex = this.currentTex;
        return resize;
    }

    public void begin() {
        this.setTexture(0);
    }

    public void end() {
        int i = 0;
        while (i < this.textures.length) {
            this.pgl.disableTexturing(this.textures[i].glTarget);
            ++i;
        }
    }

    public void setTexture(int idx) {
        if (idx >= 0 && idx < this.textures.length) {
            this.currentTex = idx;
        }
    }

    public PImage getTexture(int idx) {
        if (idx >= 0 && idx < this.images.length) {
            return this.images[idx];
        }
        return null;
    }

    public PImage getCurrentTexture() {
        return this.getTexture(this.currentTex);
    }

    public void addAllGlyphsToTexture() {
        int i = 0;
        while (i < this.font.getGlyphCount()) {
            this.addToTexture(i, this.font.getGlyph(i));
            ++i;
        }
    }

    public void updateGlyphsTexCoords() {
        int i = 0;
        while (i < this.glyphTexinfos.length) {
            TextureInfo tinfo = this.glyphTexinfos[i];
            if (tinfo != null && tinfo.texIndex == this.currentTex) {
                tinfo.updateUV();
            }
            ++i;
        }
    }

    public TextureInfo getTexInfo(PFont.Glyph glyph) {
        TextureInfo info = this.texinfoMap.get(glyph);
        return info;
    }

    public TextureInfo addToTexture(PFont.Glyph glyph) {
        int n = this.glyphTexinfos.length;
        if (n == 0) {
            this.glyphTexinfos = new TextureInfo[1];
        }
        this.addToTexture(n, glyph);
        return this.glyphTexinfos[n];
    }

    public boolean contextIsOutdated() {
        boolean outdated = false;
        int i = 0;
        while (i < this.textures.length) {
            if (this.textures[i].contextIsOutdated()) {
                outdated = true;
            }
            ++i;
        }
        if (outdated) {
            i = 0;
            while (i < this.textures.length) {
                this.pg.removeTextureObject(this.textures[i].glName, this.textures[i].context.code());
                this.textures[i].glName = 0;
                ++i;
            }
        }
        return outdated;
    }

    protected void addToTexture(int idx, PFont.Glyph glyph) {
        int x;
        int y;
        int w = 1 + glyph.width + 1;
        int h = 1 + glyph.height + 1;
        int[] rgba = new int[w * h];
        int t = 0;
        int p = 0;
        if (PGL.BIG_ENDIAN) {
            Arrays.fill(rgba, 0, w, -256);
            t = w;
            y = 0;
            while (y < glyph.height) {
                rgba[t++] = -256;
                x = 0;
                while (x < glyph.width) {
                    rgba[t++] = 0xFFFFFF00 | glyph.image.pixels[p++];
                    ++x;
                }
                rgba[t++] = -256;
                ++y;
            }
            Arrays.fill(rgba, (h - 1) * w, h * w, -256);
        } else {
            Arrays.fill(rgba, 0, w, 0xFFFFFF);
            t = w;
            y = 0;
            while (y < glyph.height) {
                rgba[t++] = 0xFFFFFF;
                x = 0;
                while (x < glyph.width) {
                    rgba[t++] = glyph.image.pixels[p++] << 24 | 0xFFFFFF;
                    ++x;
                }
                rgba[t++] = 0xFFFFFF;
                ++y;
            }
            Arrays.fill(rgba, (h - 1) * w, h * w, 0xFFFFFF);
        }
        if (this.offsetX + w > this.textures[this.currentTex].glWidth) {
            this.offsetX = 0;
            this.offsetY += this.lineHeight;
            this.lineHeight = 0;
        }
        this.lineHeight = Math.max(this.lineHeight, h);
        boolean resized = false;
        if (this.offsetY + this.lineHeight > this.textures[this.currentTex].glHeight) {
            resized = this.addTexture();
            if (resized) {
                this.updateGlyphsTexCoords();
            } else {
                this.offsetX = 0;
                this.offsetY = 0;
                this.lineHeight = 0;
            }
        }
        if (this.lastTex == -1) {
            this.lastTex = 0;
        }
        if (this.currentTex != this.lastTex || resized) {
            this.currentTex = idx;
        }
        TextureInfo tinfo = new TextureInfo(this.currentTex, this.offsetX, this.offsetY, w, h, rgba);
        this.offsetX += w;
        if (idx == this.glyphTexinfos.length) {
            TextureInfo[] temp = new TextureInfo[this.glyphTexinfos.length + 1];
            System.arraycopy(this.glyphTexinfos, 0, temp, 0, this.glyphTexinfos.length);
            this.glyphTexinfos = temp;
        }
        this.glyphTexinfos[idx] = tinfo;
        this.texinfoMap.put(glyph, tinfo);
    }

    public class TextureInfo {
        public int texIndex;
        public int width;
        public int height;
        public int[] crop;
        public float u0;
        public float u1;
        public float v0;
        public float v1;
        public int[] pixels;

        public TextureInfo(int tidx, int cropX, int cropY, int cropW, int cropH, int[] pix) {
            this.texIndex = tidx;
            this.crop = new int[4];
            this.crop[0] = cropX + 1;
            this.crop[1] = cropY + 1 + cropH - 2;
            this.crop[2] = cropW - 2;
            this.crop[3] = -cropH + 2;
            this.pixels = pix;
            this.updateUV();
            this.updateTex();
        }

        void updateUV() {
            this.width = PFontTexture.this.textures[this.texIndex].glWidth;
            this.height = PFontTexture.this.textures[this.texIndex].glHeight;
            this.u0 = (float)this.crop[0] / (float)this.width;
            this.u1 = this.u0 + (float)this.crop[2] / (float)this.width;
            this.v0 = (float)(this.crop[1] + this.crop[3]) / (float)this.height;
            this.v1 = this.v0 - (float)this.crop[3] / (float)this.height;
        }

        void updateTex() {
            PFontTexture.this.textures[this.texIndex].setNative(this.pixels, 0, this.crop[0] - 1, this.crop[1] + this.crop[3] - 1, this.crop[2] + 2, -this.crop[3] + 2);
        }
    }
}

