/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import com.jogamp.newt.Window;
import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.util.AnimatorBase;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Component;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GL2ES2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLCanvas;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUtessellator;
import javax.media.opengl.glu.GLUtessellatorCallback;
import javax.media.opengl.glu.GLUtessellatorCallbackAdapter;
import processing.opengl.PGraphicsOpenGL;

public class PGL {
    public static final int AWT = 0;
    public static final int NEWT = 1;
    public static final int SIZEOF_SHORT = 2;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_INDEX = 2;
    public static final int INDEX_TYPE = 5123;
    public static final int DEFAULT_IN_VERTICES = 64;
    public static final int DEFAULT_IN_EDGES = 128;
    public static final int DEFAULT_IN_TEXTURES = 64;
    public static final int DEFAULT_TESS_VERTICES = 64;
    public static final int DEFAULT_TESS_INDICES = 128;
    public static final int MAX_LIGHTS = 8;
    public static final int MAX_VERTEX_INDEX = Short.MAX_VALUE;
    public static final int MAX_VERTEX_INDEX1 = 32768;
    public static final int FLUSH_VERTEX_COUNT = 32768;
    public static final int MAX_FONT_TEX_SIZE = 1024;
    public static final float MIN_CAPS_JOINS_WEIGHT = 1.5f;
    public static final int MAX_CAPS_JOINS_LENGTH = 5000;
    protected static final int MIN_ARRAYCOPY_SIZE = 2;
    protected static final boolean MIPMAPS_ENABLED = true;
    public static float FLOAT_EPS = Float.MIN_VALUE;
    public static boolean BIG_ENDIAN;
    protected static final String SHADER_PREPROCESSOR_DIRECTIVE = "#ifdef GL_ES\nprecision mediump float;\nprecision mediump int;\n#endif\n";
    public static final int GL_FALSE = 0;
    public static final int GL_TRUE = 1;
    public static final int GL_LESS = 513;
    public static final int GL_LEQUAL = 515;
    public static final int GL_CCW = 2305;
    public static final int GL_CW = 2304;
    public static final int GL_CULL_FACE = 2884;
    public static final int GL_FRONT = 1028;
    public static final int GL_BACK = 1029;
    public static final int GL_FRONT_AND_BACK = 1032;
    public static final int GL_VIEWPORT = 2978;
    public static final int GL_SCISSOR_TEST = 3089;
    public static final int GL_DEPTH_TEST = 2929;
    public static final int GL_DEPTH_WRITEMASK = 2930;
    public static final int GL_COLOR_BUFFER_BIT = 16384;
    public static final int GL_DEPTH_BUFFER_BIT = 256;
    public static final int GL_STENCIL_BUFFER_BIT = 1024;
    public static final int GL_FUNC_ADD = 32774;
    public static final int GL_FUNC_MIN = 32775;
    public static final int GL_FUNC_MAX = 32776;
    public static final int GL_FUNC_REVERSE_SUBTRACT = 32779;
    public static final int GL_TEXTURE_2D = 3553;
    public static final int GL_TEXTURE_RECTANGLE = 34037;
    public static final int GL_TEXTURE_BINDING_2D = 32873;
    public static final int GL_TEXTURE_BINDING_RECTANGLE = 34038;
    public static final int GL_RGB = 6407;
    public static final int GL_RGBA = 6408;
    public static final int GL_ALPHA = 6406;
    public static final int GL_UNSIGNED_INT = 5125;
    public static final int GL_UNSIGNED_BYTE = 5121;
    public static final int GL_UNSIGNED_SHORT = 5123;
    public static final int GL_FLOAT = 5126;
    public static final int GL_NEAREST = 9728;
    public static final int GL_LINEAR = 9729;
    public static final int GL_LINEAR_MIPMAP_NEAREST = 9985;
    public static final int GL_LINEAR_MIPMAP_LINEAR = 9987;
    public static final int GL_CLAMP_TO_EDGE = 33071;
    public static final int GL_REPEAT = 10497;
    public static final int GL_RGBA8 = 32856;
    public static final int GL_DEPTH24_STENCIL8 = 35056;
    public static final int GL_DEPTH_COMPONENT = 6402;
    public static final int GL_DEPTH_COMPONENT16 = 33189;
    public static final int GL_DEPTH_COMPONENT24 = 33190;
    public static final int GL_DEPTH_COMPONENT32 = 33191;
    public static final int GL_STENCIL_INDEX = 6401;
    public static final int GL_STENCIL_INDEX1 = 36166;
    public static final int GL_STENCIL_INDEX4 = 36167;
    public static final int GL_STENCIL_INDEX8 = 36168;
    public static final int GL_ARRAY_BUFFER = 34962;
    public static final int GL_ELEMENT_ARRAY_BUFFER = 34963;
    public static final int GL_SAMPLES = 32937;
    public static final int GL_FRAMEBUFFER_COMPLETE = 36053;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT = 36054;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 36055;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS = 36057;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_FORMATS = 36058;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER = 36059;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER = 36060;
    public static final int GL_FRAMEBUFFER_UNSUPPORTED = 36061;
    public static final int GL_STATIC_DRAW = 35044;
    public static final int GL_DYNAMIC_DRAW = 35048;
    public static final int GL_STREAM_DRAW = 35040;
    public static final int GL_READ_ONLY = 35000;
    public static final int GL_WRITE_ONLY = 35001;
    public static final int GL_READ_WRITE = 35002;
    public static final int GL_TRIANGLE_FAN = 6;
    public static final int GL_TRIANGLE_STRIP = 5;
    public static final int GL_TRIANGLES = 4;
    public static final int GL_VENDOR = 7936;
    public static final int GL_RENDERER = 7937;
    public static final int GL_VERSION = 7938;
    public static final int GL_EXTENSIONS = 7939;
    public static final int GL_SHADING_LANGUAGE_VERSION = 35724;
    public static final int GL_MAX_TEXTURE_SIZE = 3379;
    public static final int GL_MAX_SAMPLES = 36183;
    public static final int GL_ALIASED_LINE_WIDTH_RANGE = 33902;
    public static final int GL_ALIASED_POINT_SIZE_RANGE = 33901;
    public static final int GL_DEPTH_BITS = 3414;
    public static final int GL_STENCIL_BITS = 3415;
    public static final int GLU_TESS_WINDING_NONZERO = 100131;
    public static final int GLU_TESS_WINDING_ODD = 100130;
    public static final int GL_TEXTURE0 = 33984;
    public static final int GL_TEXTURE1 = 33985;
    public static final int GL_TEXTURE2 = 33986;
    public static final int GL_TEXTURE3 = 33987;
    public static final int GL_TEXTURE_MIN_FILTER = 10241;
    public static final int GL_TEXTURE_MAG_FILTER = 10240;
    public static final int GL_TEXTURE_WRAP_S = 10242;
    public static final int GL_TEXTURE_WRAP_T = 10243;
    public static final int GL_BLEND = 3042;
    public static final int GL_ONE = 1;
    public static final int GL_ZERO = 0;
    public static final int GL_SRC_ALPHA = 770;
    public static final int GL_DST_ALPHA = 772;
    public static final int GL_ONE_MINUS_SRC_ALPHA = 771;
    public static final int GL_ONE_MINUS_DST_COLOR = 775;
    public static final int GL_ONE_MINUS_SRC_COLOR = 769;
    public static final int GL_DST_COLOR = 774;
    public static final int GL_SRC_COLOR = 768;
    public static final int GL_FRAMEBUFFER = 36160;
    public static final int GL_COLOR_ATTACHMENT0 = 36064;
    public static final int GL_COLOR_ATTACHMENT1 = 36065;
    public static final int GL_COLOR_ATTACHMENT2 = 36066;
    public static final int GL_COLOR_ATTACHMENT3 = 36067;
    public static final int GL_RENDERBUFFER = 36161;
    public static final int GL_DEPTH_ATTACHMENT = 36096;
    public static final int GL_STENCIL_ATTACHMENT = 36128;
    public static final int GL_READ_FRAMEBUFFER = 36008;
    public static final int GL_DRAW_FRAMEBUFFER = 36009;
    public static final int GL_VERTEX_SHADER = 35633;
    public static final int GL_FRAGMENT_SHADER = 35632;
    public static final int GL_INFO_LOG_LENGTH = 35716;
    public static final int GL_SHADER_SOURCE_LENGTH = 35720;
    public static final int GL_COMPILE_STATUS = 35713;
    public static final int GL_LINK_STATUS = 35714;
    public static final int GL_VALIDATE_STATUS = 35715;
    public static final int GL_MULTISAMPLE = 32925;
    public static final int GL_POINT_SMOOTH = 2832;
    public static final int GL_LINE_SMOOTH = 2848;
    public static final int GL_POLYGON_SMOOTH = 2881;
    public GL gl;
    public GL2ES2 gl2;
    public GL2 gl2x;
    public GLU glu;
    public PGraphicsOpenGL pg;
    public boolean initialized;
    public static int toolkit;
    public GLProfile profile;
    public GLCapabilitiesImmutable capabilities;
    public GLDrawable drawable;
    public GLContext context;
    public Canvas canvas;
    protected GLCanvas canvasAWT;
    protected NewtCanvasAWT canvasNEWT;
    protected GLWindow window;
    protected PGLListener listener;
    protected PGLAnimator animator;
    protected float targetFramerate = 60.0f;
    protected boolean setFramerate = false;
    protected static boolean[] texturingTargets;
    protected static int[] boundTextures;
    public static final boolean ENABLE_OSX_SCREEN_FBO = true;
    public static final int MIN_OSX_VER_FOR_SCREEN_FBO = 6;
    public static final int MIN_SAMPLES_FOR_SCREEN_FBO = 1;
    protected boolean needScreenFBO = false;
    protected int fboWidth;
    protected int fboHeight;
    protected int numSamples;
    protected boolean multisample;
    protected boolean packedDepthStencil;
    protected int[] glColorTex = new int[1];
    protected int[] glColorFbo = new int[1];
    protected int[] glMultiFbo = new int[1];
    protected int[] glColorRenderBuffer = new int[1];
    protected int[] glPackedDepthStencil = new int[1];
    protected int[] glDepthBuffer = new int[1];
    protected int[] glStencilBuffer = new int[1];
    protected int contextHashCode;
    protected boolean loadedTex2DShader = false;
    protected int tex2DShaderProgram;
    protected int tex2DVertShader;
    protected int tex2DFragShader;
    protected GLContext tex2DShaderContext;
    protected int tex2DVertLoc;
    protected int tex2DTCoordLoc;
    protected boolean loadedTexRectShader = false;
    protected int texRectShaderProgram;
    protected int texRectVertShader;
    protected int texRectFragShader;
    protected GLContext texRectShaderContext;
    protected int texRectVertLoc;
    protected int texRectTCoordLoc;
    protected float[] texCoords = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 1.0f, -1.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    protected FloatBuffer texData;
    protected String texVertShaderSource = "attribute vec2 inVertex;attribute vec2 inTexcoord;varying vec2 vertTexcoord;void main() {  gl_Position = vec4(inVertex, 0, 1);  vertTexcoord = inTexcoord;}";
    protected String tex2DFragShaderSource = "#ifdef GL_ES\nprecision mediump float;\nprecision mediump int;\n#endif\nuniform sampler2D textureSampler;varying vec2 vertTexcoord;void main() {  gl_FragColor = texture2D(textureSampler, vertTexcoord.st);}";
    protected String texRectFragShaderSource = "#ifdef GL_ES\nprecision mediump float;\nprecision mediump int;\n#endif\nuniform sampler2DRect textureSampler;varying vec2 vertTexcoord;void main() {  gl_FragColor = texture2DRect(textureSampler, vertTexcoord.st);}";
    protected boolean loadedRectShader = false;
    protected int rectShaderProgram;
    protected int rectVertShader;
    protected int rectFragShader;
    protected GLContext rectShaderContext;
    protected int rectVertLoc;
    protected int rectColorLoc;
    protected float[] rectCoords = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f};
    protected FloatBuffer rectData;
    protected String rectVertShaderSource = "attribute vec2 inVertex;void main() {  gl_Position = vec4(inVertex, 0, 1);}";
    protected String rectFragShaderSource = "#ifdef GL_ES\nprecision mediump float;\nprecision mediump int;\n#endif\nuniform vec4 rectColor;void main() {  gl_FragColor = rectColor;}";
    protected IntBuffer colorBuffer;
    protected FloatBuffer depthBuffer;
    protected ByteBuffer stencilBuffer;

    static {
        float eps = 1.0f;
        while ((double)((float)(1.0 + (double)(eps /= 2.0f) / 2.0)) != 1.0) {
        }
        FLOAT_EPS = eps;
        BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
        toolkit = 0;
        texturingTargets = new boolean[2];
        boundTextures = new int[2];
    }

    public PGL(PGraphicsOpenGL pg) {
        this.pg = pg;
        this.glu = new GLU();
        this.initialized = false;
    }

    public void setFrameRate(float framerate) {
        if (this.targetFramerate != framerate) {
            if (60.0f < framerate) {
                this.gl.setSwapInterval(0);
            } else if (30.0f < framerate) {
                this.gl.setSwapInterval(1);
            } else {
                this.gl.setSwapInterval(2);
            }
            if (60.0f < framerate && this.targetFramerate <= 60.0f || framerate <= 60.0f && 60.0f < this.targetFramerate) {
                this.initialized = false;
            }
            this.targetFramerate = framerate;
            this.setFramerate = true;
        }
    }

    public void setToolkit(int toolkit) {
        if (PGL.toolkit != toolkit) {
            PGL.toolkit = toolkit;
            this.initialized = false;
        }
    }

    public void initPrimarySurface(int antialias) {
        int num;
        String version;
        String[] parts;
        this.needScreenFBO = false;
        this.glColorFbo[0] = 0;
        String osName = System.getProperty("os.name");
        if (osName.equals("Mac OS X") && 2 <= (parts = (version = System.getProperty("os.version")).split("\\.")).length && 6 <= (num = Integer.parseInt(parts[1])) && 1 <= this.qualityToSamples(this.pg.quality)) {
            this.needScreenFBO = true;
        }
        if (this.profile == null) {
            this.profile = GLProfile.getDefault();
        } else {
            if (this.canvasAWT != null) {
                this.canvasAWT.removeGLEventListener((GLEventListener)this.listener);
                this.pg.parent.removeListeners((Component)this.canvasAWT);
                this.pg.parent.remove((Component)this.canvasAWT);
            } else if (this.canvasNEWT != null) {
                this.animator.stop();
                this.animator.remove((GLAutoDrawable)this.window);
                this.window.removeGLEventListener((GLEventListener)this.listener);
                this.pg.parent.removeListeners((Component)this.canvasNEWT);
                this.pg.parent.remove((Component)this.canvasNEWT);
            }
            this.setFramerate = false;
        }
        GLCapabilities caps = new GLCapabilities(this.profile);
        if (1 < antialias && !this.needScreenFBO) {
            caps.setSampleBuffers(true);
            caps.setNumSamples(antialias);
        } else {
            caps.setSampleBuffers(false);
        }
        caps.setDepthBits(24);
        caps.setStencilBits(8);
        caps.setAlphaBits(8);
        caps.setBackgroundOpaque(true);
        if (toolkit == 0) {
            this.canvasAWT = new GLCanvas((GLCapabilitiesImmutable)caps);
            this.canvasAWT.setBounds(0, 0, this.pg.width, this.pg.height);
            this.pg.parent.setLayout(new BorderLayout());
            this.pg.parent.add((Component)this.canvasAWT, "Center");
            this.pg.parent.removeListeners(this.pg.parent);
            this.pg.parent.addListeners((Component)this.canvasAWT);
            this.listener = new PGLListener();
            this.canvasAWT.addGLEventListener((GLEventListener)this.listener);
            this.capabilities = this.canvasAWT.getChosenGLCapabilities();
            this.canvas = this.canvasAWT;
            this.canvasNEWT = null;
        } else if (toolkit == 1) {
            this.window = GLWindow.create((GLCapabilitiesImmutable)caps);
            this.canvasNEWT = new NewtCanvasAWT((Window)this.window);
            this.pg.parent.setLayout(new BorderLayout());
            this.pg.parent.add((Component)this.canvasNEWT, "Center");
            this.pg.parent.removeListeners(this.pg.parent);
            this.pg.parent.addListeners((Component)this.canvasNEWT);
            this.listener = new PGLListener();
            this.window.addGLEventListener((GLEventListener)this.listener);
            this.animator = new PGLAnimator((GLAutoDrawable)this.window);
            this.animator.start();
            this.capabilities = this.window.getChosenGLCapabilities();
            this.canvas = this.canvasNEWT;
            this.canvasAWT = null;
        }
        this.initialized = true;
    }

    public void initOffscreenSurface(PGL primary) {
        this.context = primary.context;
        this.capabilities = primary.capabilities;
        this.drawable = null;
        this.initialized = true;
    }

    public void updatePrimary() {
        if (!this.setFramerate) {
            this.setFrameRate(this.targetFramerate);
        }
        if (this.needScreenFBO && this.glColorFbo[0] == 0) {
            this.numSamples = this.qualityToSamples(this.pg.quality);
            String ext = this.gl.glGetString(7939);
            if (-1 < ext.indexOf("texture_non_power_of_two")) {
                this.fboWidth = this.pg.width;
                this.fboHeight = this.pg.height;
            } else {
                this.fboWidth = PGL.nextPowerOfTwo(this.pg.width);
                this.fboHeight = PGL.nextPowerOfTwo(this.pg.height);
            }
            boolean bl = this.multisample = 1 < this.numSamples;
            if (this.multisample && this.gl2x == null) {
                throw new RuntimeException("Doesn't have the OpenGL extensions necessary for multisampling.");
            }
            this.packedDepthStencil = ext.indexOf("packed_depth_stencil") != -1;
            this.contextHashCode = this.context.hashCode();
            this.gl.glGenTextures(1, this.glColorTex, 0);
            this.gl.glBindTexture(3553, this.glColorTex[0]);
            this.gl.glTexParameteri(3553, 10241, 9728);
            this.gl.glTexParameteri(3553, 10240, 9728);
            this.gl.glTexParameteri(3553, 10242, 33071);
            this.gl.glTexParameteri(3553, 10243, 33071);
            this.gl.glTexImage2D(3553, 0, 6408, this.fboWidth, this.fboHeight, 0, 6408, 5121, null);
            this.gl.glBindTexture(3553, 0);
            this.gl.glGenFramebuffers(1, this.glColorFbo, 0);
            this.gl.glBindFramebuffer(36160, this.glColorFbo[0]);
            this.gl.glFramebufferTexture2D(36160, 36064, 3553, this.glColorTex[0], 0);
            this.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            this.gl.glClear(16384);
            if (this.multisample) {
                this.gl.glBindFramebuffer(36160, 0);
                this.gl.glGenFramebuffers(1, this.glMultiFbo, 0);
                this.gl.glBindFramebuffer(36160, this.glMultiFbo[0]);
                this.gl.glGenRenderbuffers(1, this.glColorRenderBuffer, 0);
                this.gl.glBindRenderbuffer(36161, this.glColorRenderBuffer[0]);
                this.gl2x.glRenderbufferStorageMultisample(36161, this.numSamples, 32856, this.fboWidth, this.fboHeight);
                this.gl.glFramebufferRenderbuffer(36160, 36064, 36161, this.glColorRenderBuffer[0]);
                if (this.packedDepthStencil) {
                    this.gl.glGenRenderbuffers(1, this.glPackedDepthStencil, 0);
                    this.gl.glBindRenderbuffer(36161, this.glPackedDepthStencil[0]);
                    this.gl2x.glRenderbufferStorageMultisample(36161, this.numSamples, 35056, this.fboWidth, this.fboHeight);
                    this.gl.glFramebufferRenderbuffer(36160, 36096, 36161, this.glPackedDepthStencil[0]);
                    this.gl.glFramebufferRenderbuffer(36160, 36128, 36161, this.glPackedDepthStencil[0]);
                } else {
                    this.gl.glGenRenderbuffers(1, this.glDepthBuffer, 0);
                    this.gl.glBindRenderbuffer(36161, this.glDepthBuffer[0]);
                    this.gl2x.glRenderbufferStorageMultisample(36161, this.numSamples, 33190, this.fboWidth, this.fboHeight);
                    this.gl.glFramebufferRenderbuffer(36160, 36096, 36161, this.glDepthBuffer[0]);
                    this.gl.glGenRenderbuffers(1, this.glStencilBuffer, 0);
                    this.gl.glBindRenderbuffer(36161, this.glStencilBuffer[0]);
                    this.gl2x.glRenderbufferStorageMultisample(36161, this.numSamples, 36168, this.fboWidth, this.fboHeight);
                    this.gl.glFramebufferRenderbuffer(36160, 36128, 36161, this.glStencilBuffer[0]);
                }
                this.gl.glClearDepth(1.0);
                this.gl.glClearStencil(0);
                this.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
                this.gl.glClear(17664);
                this.gl.glBindFramebuffer(36160, this.glColorFbo[0]);
            } else {
                if (this.packedDepthStencil) {
                    this.gl.glGenRenderbuffers(1, this.glPackedDepthStencil, 0);
                    this.gl.glBindRenderbuffer(36161, this.glPackedDepthStencil[0]);
                    this.gl.glRenderbufferStorage(36161, 35056, this.fboWidth, this.fboHeight);
                    this.gl.glFramebufferRenderbuffer(36160, 36096, 36161, this.glPackedDepthStencil[0]);
                    this.gl.glFramebufferRenderbuffer(36160, 36128, 36161, this.glPackedDepthStencil[0]);
                } else {
                    this.gl.glGenRenderbuffers(1, this.glDepthBuffer, 0);
                    this.gl.glBindRenderbuffer(36161, this.glDepthBuffer[0]);
                    this.gl.glRenderbufferStorage(36161, 33190, this.fboWidth, this.fboHeight);
                    this.gl.glFramebufferRenderbuffer(36160, 36096, 36161, this.glDepthBuffer[0]);
                    this.gl.glGenRenderbuffers(1, this.glStencilBuffer, 0);
                    this.gl.glBindRenderbuffer(36161, this.glStencilBuffer[0]);
                    this.gl.glRenderbufferStorage(36161, 36168, this.fboWidth, this.fboHeight);
                    this.gl.glFramebufferRenderbuffer(36160, 36128, 36161, this.glStencilBuffer[0]);
                }
                this.gl.glClearDepth(1.0);
                this.gl.glClearStencil(0);
                this.gl.glClear(1280);
            }
            PGraphicsOpenGL.screenFramebuffer.glFbo = this.glColorFbo[0];
        } else {
            PGraphicsOpenGL.screenFramebuffer.glFbo = 0;
        }
    }

    public void updateOffscreen(PGL primary) {
        this.gl = primary.gl;
        this.gl2 = primary.gl2;
        this.gl2x = primary.gl2x;
    }

    public boolean primaryIsDoubleBuffered() {
        return this.glColorFbo[0] == 0;
    }

    public boolean primaryIsFboBacked() {
        return this.glColorFbo[0] != 0;
    }

    public int getFboTexTarget() {
        return 3553;
    }

    public int getFboTexName() {
        return this.glColorTex[0];
    }

    public int getFboWidth() {
        return this.fboWidth;
    }

    public int getFboHeight() {
        return this.fboHeight;
    }

    public void bindPrimaryColorFBO() {
        if (this.multisample) {
            this.gl.glBindFramebuffer(36008, this.glMultiFbo[0]);
            this.gl.glBindFramebuffer(36009, this.glColorFbo[0]);
            this.gl2x.glBlitFramebuffer(0, 0, this.fboWidth, this.fboHeight, 0, 0, this.fboWidth, this.fboHeight, 16384, 9728);
        }
        this.gl.glBindFramebuffer(36160, this.glColorFbo[0]);
        PGraphicsOpenGL.screenFramebuffer.glFbo = this.glColorFbo[0];
        this.gl.glColorMask(false, false, false, true);
        this.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.gl.glClear(16384);
        this.gl.glColorMask(true, true, true, true);
    }

    public void bindPrimaryMultiFBO() {
        if (this.multisample) {
            this.gl.glBindFramebuffer(36160, this.glMultiFbo[0]);
            PGraphicsOpenGL.screenFramebuffer.glFbo = this.glMultiFbo[0];
        }
    }

    protected void releaseScreenFBO() {
        this.gl.glDeleteTextures(1, this.glColorTex, 0);
        this.gl.glDeleteFramebuffers(1, this.glColorFbo, 0);
        if (this.packedDepthStencil) {
            this.gl.glDeleteRenderbuffers(1, this.glPackedDepthStencil, 0);
        } else {
            this.gl.glDeleteRenderbuffers(1, this.glDepthBuffer, 0);
            this.gl.glDeleteRenderbuffers(1, this.glStencilBuffer, 0);
        }
        if (this.multisample) {
            this.gl.glDeleteFramebuffers(1, this.glMultiFbo, 0);
            this.gl.glDeleteRenderbuffers(1, this.glColorRenderBuffer, 0);
        }
    }

    protected int qualityToSamples(int quality) {
        if (quality <= 1) {
            return 1;
        }
        int n = 2 * (quality / 2);
        return n;
    }

    public void beginOnscreenDraw(boolean clear) {
        if (this.glColorFbo[0] != 0) {
            if (this.multisample) {
                this.gl.glBindFramebuffer(36160, this.glMultiFbo[0]);
                this.gl2x.glDrawBuffer(36064);
                PGraphicsOpenGL.screenFramebuffer.glFbo = this.glMultiFbo[0];
            } else {
                this.gl.glBindFramebuffer(36160, this.glColorFbo[0]);
                if (this.gl2x != null) {
                    this.gl2x.glDrawBuffer(36064);
                }
                PGraphicsOpenGL.screenFramebuffer.glFbo = this.glColorFbo[0];
            }
        }
    }

    public void endOnscreenDraw(boolean clear0) {
        if (this.glColorFbo[0] != 0) {
            if (this.multisample) {
                this.gl.glBindFramebuffer(36008, this.glMultiFbo[0]);
                this.gl.glBindFramebuffer(36009, this.glColorFbo[0]);
                this.gl2x.glBlitFramebuffer(0, 0, this.fboWidth, this.fboHeight, 0, 0, this.fboWidth, this.fboHeight, 16384, 9728);
            }
            this.gl.glBindFramebuffer(36160, 0);
            this.gl.glClearDepth(1.0);
            this.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            this.gl.glClear(1280);
            this.gl.glDisable(3042);
            this.drawTexture(3553, this.glColorTex[0], this.fboWidth, this.fboHeight, 0, 0, this.pg.width, this.pg.height, 0, 0, this.pg.width, this.pg.height);
            this.gl.glBindFramebuffer(36160, this.glColorFbo[0]);
            PGraphicsOpenGL.screenFramebuffer.glFbo = this.glColorFbo[0];
        }
    }

    public void beginOffscreenDraw(boolean clear) {
    }

    public void endOffscreenDraw(boolean clear0) {
    }

    public boolean canDraw() {
        return this.initialized && this.pg.parent.isDisplayable();
    }

    public void requestDraw() {
        if (this.initialized) {
            if (toolkit == 0) {
                this.canvasAWT.display();
            } else if (toolkit == 1) {
                this.animator.requestDisplay();
            }
        }
    }

    public String glGetString(int name) {
        return this.gl.glGetString(name);
    }

    public void glGetIntegerv(int name, int[] values, int offset) {
        this.gl.glGetIntegerv(name, values, offset);
    }

    public void glGetBooleanv(int name, boolean[] values, int offset) {
        if (-1 < name) {
            byte[] bvalues = new byte[values.length];
            this.gl.glGetBooleanv(name, bvalues, offset);
            int i = 0;
            while (i < values.length) {
                values[i] = bvalues[i] != 0;
                ++i;
            }
        } else {
            Arrays.fill(values, false);
        }
    }

    public void glEnable(int cap) {
        if (-1 < cap) {
            this.gl.glEnable(cap);
        }
    }

    public void glDisable(int cap) {
        if (-1 < cap) {
            this.gl.glDisable(cap);
        }
    }

    public void glFlush() {
        this.gl.glFlush();
    }

    public void glFinish() {
        this.gl.glFinish();
    }

    public int glGetError() {
        return this.gl.glGetError();
    }

    public String glErrorString(int err) {
        return this.glu.gluErrorString(err);
    }

    public String gluErrorString(int err) {
        return this.glu.gluErrorString(err);
    }

    public void glFrontFace(int mode) {
        this.gl.glFrontFace(mode);
    }

    public void glCullFace(int mode) {
        this.gl.glCullFace(mode);
    }

    public void glDepthMask(boolean flag) {
        this.gl.glDepthMask(flag);
    }

    public void glDepthFunc(int func) {
        this.gl.glDepthFunc(func);
    }

    public void glGenTextures(int n, int[] ids, int offset) {
        this.gl.glGenTextures(n, ids, offset);
    }

    public void glDeleteTextures(int n, int[] ids, int offset) {
        this.gl.glDeleteTextures(n, ids, offset);
    }

    public void glActiveTexture(int unit) {
        this.gl.glActiveTexture(unit);
    }

    public void glBindTexture(int target, int id) {
        this.gl.glBindTexture(target, id);
        if (target == 3553) {
            PGL.boundTextures[0] = id;
        } else if (target == 34037) {
            PGL.boundTextures[1] = id;
        }
    }

    public void glTexImage2D(int target, int level, int internalFormat, int width, int height, int border, int format, int type, Buffer data) {
        this.gl.glTexImage2D(target, level, internalFormat, width, height, border, format, type, data);
    }

    public void glTexSubImage2D(int target, int level, int xOffset, int yOffset, int width, int height, int format, int type, Buffer data) {
        this.gl.glTexSubImage2D(target, level, xOffset, yOffset, width, height, format, type, data);
    }

    public void glTexParameteri(int target, int param, int value) {
        this.gl.glTexParameteri(target, param, value);
    }

    public void glGetTexParameteriv(int target, int param, int[] values, int offset) {
        this.gl.glGetTexParameteriv(target, param, values, offset);
    }

    public void glGenerateMipmap(int target) {
        this.gl.glGenerateMipmap(target);
    }

    public void glGenBuffers(int n, int[] ids, int offset) {
        this.gl.glGenBuffers(n, ids, offset);
    }

    public void glDeleteBuffers(int n, int[] ids, int offset) {
        this.gl.glDeleteBuffers(n, ids, offset);
    }

    public void glBindBuffer(int target, int id) {
        this.gl.glBindBuffer(target, id);
    }

    public void glBufferData(int target, int size, Buffer data, int usage) {
        this.gl.glBufferData(target, (long)size, data, usage);
    }

    public void glBufferSubData(int target, int offset, int size, Buffer data) {
        this.gl.glBufferSubData(target, (long)offset, (long)size, data);
    }

    public void glDrawArrays(int mode, int first, int count) {
        this.gl.glDrawArrays(mode, first, count);
    }

    public void glDrawElements(int mode, int count, int type, int offset) {
        this.gl.glDrawElements(mode, count, type, (long)offset);
    }

    public void glEnableVertexAttribArray(int loc) {
        this.gl2.glEnableVertexAttribArray(loc);
    }

    public void glDisableVertexAttribArray(int loc) {
        this.gl2.glDisableVertexAttribArray(loc);
    }

    public void glVertexAttribPointer(int loc, int size, int type, boolean normalized, int stride, int offset) {
        this.gl2.glVertexAttribPointer(loc, size, type, normalized, stride, (long)offset);
    }

    public void glVertexAttribPointer(int loc, int size, int type, boolean normalized, int stride, Buffer data) {
        this.gl2.glVertexAttribPointer(loc, size, type, normalized, stride, data);
    }

    public ByteBuffer glMapBuffer(int target, int access) {
        return this.gl2.glMapBuffer(target, access);
    }

    public ByteBuffer glMapBufferRange(int target, int offset, int length, int access) {
        if (this.gl2x != null) {
            return this.gl2x.glMapBufferRange(target, (long)offset, (long)length, access);
        }
        return null;
    }

    public void glUnmapBuffer(int target) {
        this.gl2.glUnmapBuffer(target);
    }

    public void glGenFramebuffers(int n, int[] ids, int offset) {
        this.gl.glGenFramebuffers(n, ids, offset);
    }

    public void glDeleteFramebuffers(int n, int[] ids, int offset) {
        this.gl.glDeleteFramebuffers(n, ids, offset);
    }

    public void glGenRenderbuffers(int n, int[] ids, int offset) {
        this.gl.glGenRenderbuffers(n, ids, offset);
    }

    public void glDeleteRenderbuffers(int n, int[] ids, int offset) {
        this.gl.glDeleteRenderbuffers(n, ids, offset);
    }

    public void glBindFramebuffer(int target, int id) {
        this.gl.glBindFramebuffer(target, id);
    }

    public void glBlitFramebuffer(int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter) {
        if (this.gl2x != null) {
            this.gl2x.glBlitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
        }
    }

    public void glFramebufferTexture2D(int target, int attachment, int texTarget, int texId, int level) {
        this.gl.glFramebufferTexture2D(target, attachment, texTarget, texId, level);
    }

    public void glBindRenderbuffer(int target, int id) {
        this.gl.glBindRenderbuffer(target, id);
    }

    public void glRenderbufferStorageMultisample(int target, int samples, int format, int width, int height) {
        if (this.gl2x != null) {
            this.gl2x.glRenderbufferStorageMultisample(target, samples, format, width, height);
        }
    }

    public void glRenderbufferStorage(int target, int format, int width, int height) {
        this.gl.glRenderbufferStorage(target, format, width, height);
    }

    public void glFramebufferRenderbuffer(int target, int attachment, int rendbufTarget, int rendbufId) {
        this.gl.glFramebufferRenderbuffer(target, attachment, rendbufTarget, rendbufId);
    }

    public int glCheckFramebufferStatus(int target) {
        return this.gl.glCheckFramebufferStatus(target);
    }

    public int glCreateProgram() {
        return this.gl2.glCreateProgram();
    }

    public void glDeleteProgram(int id) {
        this.gl2.glDeleteProgram(id);
    }

    public int glCreateShader(int type) {
        return this.gl2.glCreateShader(type);
    }

    public void glDeleteShader(int id) {
        this.gl2.glDeleteShader(id);
    }

    public void glLinkProgram(int prog) {
        this.gl2.glLinkProgram(prog);
    }

    public void glValidateProgram(int prog) {
        this.gl2.glValidateProgram(prog);
    }

    public void glUseProgram(int prog) {
        this.gl2.glUseProgram(prog);
    }

    public int glGetAttribLocation(int prog, String name) {
        return this.gl2.glGetAttribLocation(prog, name);
    }

    public int glGetUniformLocation(int prog, String name) {
        return this.gl2.glGetUniformLocation(prog, name);
    }

    public void glUniform1i(int loc, int value) {
        this.gl2.glUniform1i(loc, value);
    }

    public void glUniform2i(int loc, int value0, int value1) {
        this.gl2.glUniform2i(loc, value0, value1);
    }

    public void glUniform3i(int loc, int value0, int value1, int value2) {
        this.gl2.glUniform3i(loc, value0, value1, value2);
    }

    public void glUniform4i(int loc, int value0, int value1, int value2, int value3) {
        this.gl2.glUniform4i(loc, value0, value1, value2, value3);
    }

    public void glUniform1f(int loc, float value) {
        this.gl2.glUniform1f(loc, value);
    }

    public void glUniform2f(int loc, float value0, float value1) {
        this.gl2.glUniform2f(loc, value0, value1);
    }

    public void glUniform3f(int loc, float value0, float value1, float value2) {
        this.gl2.glUniform3f(loc, value0, value1, value2);
    }

    public void glUniform4f(int loc, float value0, float value1, float value2, float value3) {
        this.gl2.glUniform4f(loc, value0, value1, value2, value3);
    }

    public void glUniform1iv(int loc, int count, int[] v, int offset) {
        this.gl2.glUniform1iv(loc, count, v, offset);
    }

    public void glUniform2iv(int loc, int count, int[] v, int offset) {
        this.gl2.glUniform2iv(loc, count, v, offset);
    }

    public void glUniform3iv(int loc, int count, int[] v, int offset) {
        this.gl2.glUniform3iv(loc, count, v, offset);
    }

    public void glUniform4iv(int loc, int count, int[] v, int offset) {
        this.gl2.glUniform4iv(loc, count, v, offset);
    }

    public void glUniform1fv(int loc, int count, float[] v, int offset) {
        this.gl2.glUniform1fv(loc, count, v, offset);
    }

    public void glUniform2fv(int loc, int count, float[] v, int offset) {
        this.gl2.glUniform2fv(loc, count, v, offset);
    }

    public void glUniform3fv(int loc, int count, float[] v, int offset) {
        this.gl2.glUniform3fv(loc, count, v, offset);
    }

    public void glUniform4fv(int loc, int count, float[] v, int offset) {
        this.gl2.glUniform4fv(loc, count, v, offset);
    }

    public void glUniformMatrix2fv(int loc, int count, boolean transpose, float[] mat, int offset) {
        this.gl2.glUniformMatrix2fv(loc, count, transpose, mat, offset);
    }

    public void glUniformMatrix3fv(int loc, int count, boolean transpose, float[] mat, int offset) {
        this.gl2.glUniformMatrix3fv(loc, count, transpose, mat, offset);
    }

    public void glUniformMatrix4fv(int loc, int count, boolean transpose, float[] mat, int offset) {
        this.gl2.glUniformMatrix4fv(loc, count, transpose, mat, offset);
    }

    public void glVertexAttrib1f(int loc, float value) {
        this.gl2.glVertexAttrib1f(loc, value);
    }

    public void glVertexAttrib2f(int loc, float value0, float value1) {
        this.gl2.glVertexAttrib2f(loc, value0, value1);
    }

    public void glVertexAttrib3f(int loc, float value0, float value1, float value2) {
        this.gl2.glVertexAttrib3f(loc, value0, value1, value2);
    }

    public void glVertexAttrib4f(int loc, float value0, float value1, float value2, float value3) {
        this.gl2.glVertexAttrib4f(loc, value0, value1, value2, value3);
    }

    public void glVertexAttrib1fv(int loc, float[] v, int offset) {
        this.gl2.glVertexAttrib1fv(loc, v, offset);
    }

    public void glVertexAttrib2fv(int loc, float[] v, int offset) {
        this.gl2.glVertexAttrib2fv(loc, v, offset);
    }

    public void glVertexAttrib3fv(int loc, float[] v, int offset) {
        this.gl2.glVertexAttrib3fv(loc, v, offset);
    }

    public void glVertexAttrib4fv(int loc, float[] v, int offset) {
        this.gl2.glVertexAttrib4fv(loc, v, offset);
    }

    public void glShaderSource(int id, String source) {
        this.gl2.glShaderSource(id, 1, new String[]{source}, null, 0);
    }

    public void glCompileShader(int id) {
        this.gl2.glCompileShader(id);
    }

    public void glAttachShader(int prog, int shader) {
        this.gl2.glAttachShader(prog, shader);
    }

    public void glGetShaderiv(int shader, int pname, int[] params, int offset) {
        this.gl2.glGetShaderiv(shader, pname, params, offset);
    }

    public String glGetShaderInfoLog(int shader) {
        int[] val = new int[1];
        this.gl2.glGetShaderiv(shader, 35716, val, 0);
        int length = val[0];
        byte[] log = new byte[length];
        this.gl2.glGetShaderInfoLog(shader, length, val, 0, log, 0);
        return new String(log);
    }

    public void glGetProgramiv(int prog, int pname, int[] params, int offset) {
        this.gl2.glGetProgramiv(prog, pname, params, offset);
    }

    public String glGetProgramInfoLog(int prog) {
        int[] val = new int[1];
        this.gl2.glGetShaderiv(prog, 35716, val, 0);
        int length = val[0];
        byte[] log = new byte[length];
        this.gl2.glGetProgramInfoLog(prog, length, val, 0, log, 0);
        return new String(log);
    }

    public void glViewport(int x, int y, int width, int height) {
        this.gl.glViewport(x, y, width, height);
    }

    public void glScissor(int x, int y, int w, int h) {
        this.gl.glScissor(x, y, w, h);
    }

    public void glBlendEquation(int eq) {
        this.gl.glBlendEquation(eq);
    }

    public void glBlendFunc(int srcFactor, int dstFactor) {
        this.gl.glBlendFunc(srcFactor, dstFactor);
    }

    public void glReadBuffer(int buf) {
        if (this.gl2x != null) {
            this.gl2x.glReadBuffer(buf);
        }
    }

    public void glReadPixels(int x, int y, int width, int height, int format, int type, Buffer buffer) {
        this.gl.glReadPixels(x, y, width, height, format, type, buffer);
    }

    public void glDrawBuffer(int buf) {
        if (this.gl2x != null) {
            this.gl2x.glDrawBuffer(buf);
        }
    }

    public void glClearDepth(float d) {
        this.gl.glClearDepthf(d);
    }

    public void glClearStencil(int s) {
        this.gl.glClearStencil(s);
    }

    public void glColorMask(boolean wr, boolean wg, boolean wb, boolean wa) {
        this.gl.glColorMask(wr, wg, wb, wa);
    }

    public void glClearColor(float r, float g, float b, float a) {
        this.gl.glClearColor(r, g, b, a);
    }

    public void glClear(int mask) {
        this.gl.glClear(mask);
    }

    public Context createEmptyContext() {
        return new Context();
    }

    public Context getCurrentContext() {
        return new Context(this.context);
    }

    public Tessellator createTessellator(TessellatorCallback callback) {
        return new Tessellator(callback);
    }

    public boolean contextIsCurrent(Context other) {
        return other == null || other.current();
    }

    public void enableTexturing(int target) {
        this.glEnable(target);
        if (target == 3553) {
            PGL.texturingTargets[0] = true;
        } else if (target == 34037) {
            PGL.texturingTargets[1] = true;
        }
    }

    public void disableTexturing(int target) {
        this.glDisable(target);
        if (target == 3553) {
            PGL.texturingTargets[0] = false;
        } else if (target == 34037) {
            PGL.texturingTargets[1] = false;
        }
    }

    public boolean texturingIsEnabled(int target) {
        if (target == 3553) {
            return texturingTargets[0];
        }
        if (target == 34037) {
            return texturingTargets[1];
        }
        return false;
    }

    public boolean textureIsBound(int target, int id) {
        if (target == 3553) {
            return boundTextures[0] == id;
        }
        if (target == 34037) {
            return boundTextures[1] == id;
        }
        return false;
    }

    public void initTexture(int target, int format, int width, int height) {
        int[] texels = new int[width * height];
        this.glTexSubImage2D(target, 0, 0, 0, width, height, format, 5121, IntBuffer.wrap(texels));
    }

    public void copyToTexture(int target, int format, int id, int x, int y, int w, int h, IntBuffer buffer) {
        this.glActiveTexture(33984);
        boolean enabledTex = false;
        if (!this.texturingIsEnabled(target)) {
            this.enableTexturing(target);
            enabledTex = true;
        }
        this.glBindTexture(target, id);
        this.glTexSubImage2D(target, 0, x, y, w, h, format, 5121, buffer);
        this.glBindTexture(target, 0);
        if (enabledTex) {
            this.disableTexturing(target);
        }
    }

    public void drawTexture(int target, int id, int width, int height, int X0, int Y0, int X1, int Y1) {
        this.drawTexture(target, id, width, height, X0, Y0, X1, Y1, X0, Y0, X1, Y1);
    }

    public void drawTexture(int target, int id, int width, int height, int texX0, int texY0, int texX1, int texY1, int scrX0, int scrY0, int scrX1, int scrY1) {
        if (target == 3553) {
            this.drawTexture2D(id, width, height, texX0, texY0, texX1, texY1, scrX0, scrY0, scrX1, scrY1);
        } else if (target == 34037) {
            this.drawTextureRect(id, width, height, texX0, texY0, texX1, texY1, scrX0, scrY0, scrX1, scrY1);
        }
    }

    public void drawTexture2D(int id, int width, int height, int texX0, int texY0, int texX1, int texY1, int scrX0, int scrY0, int scrX1, int scrY1) {
        if (!this.loadedTex2DShader || this.tex2DShaderContext.hashCode() != this.context.hashCode()) {
            this.tex2DVertShader = this.createShader(35633, this.texVertShaderSource);
            this.tex2DFragShader = this.createShader(35632, this.tex2DFragShaderSource);
            if (this.tex2DVertShader > 0 && this.tex2DFragShader > 0) {
                this.tex2DShaderProgram = this.createProgram(this.tex2DVertShader, this.tex2DFragShader);
            }
            if (this.tex2DShaderProgram > 0) {
                this.tex2DVertLoc = this.glGetAttribLocation(this.tex2DShaderProgram, "inVertex");
                this.tex2DTCoordLoc = this.glGetAttribLocation(this.tex2DShaderProgram, "inTexcoord");
            }
            this.loadedTex2DShader = true;
            this.tex2DShaderContext = this.context;
        }
        if (this.texData == null) {
            this.texData = PGL.allocateDirectFloatBuffer(this.texCoords.length);
        }
        if (this.tex2DShaderProgram > 0) {
            boolean[] depthTest = new boolean[1];
            this.glGetBooleanv(2929, depthTest, 0);
            this.glDisable(2929);
            boolean[] depthMask = new boolean[1];
            this.glGetBooleanv(2930, depthMask, 0);
            this.glDepthMask(false);
            this.glUseProgram(this.tex2DShaderProgram);
            this.glEnableVertexAttribArray(this.tex2DVertLoc);
            this.glEnableVertexAttribArray(this.tex2DTCoordLoc);
            this.texCoords[0] = 2.0f * (float)scrX0 / (float)this.pg.width - 1.0f;
            this.texCoords[1] = 2.0f * (float)scrY0 / (float)this.pg.height - 1.0f;
            this.texCoords[2] = (float)texX0 / (float)width;
            this.texCoords[3] = (float)texY0 / (float)height;
            this.texCoords[4] = 2.0f * (float)scrX1 / (float)this.pg.width - 1.0f;
            this.texCoords[5] = 2.0f * (float)scrY0 / (float)this.pg.height - 1.0f;
            this.texCoords[6] = (float)texX1 / (float)width;
            this.texCoords[7] = (float)texY0 / (float)height;
            this.texCoords[8] = 2.0f * (float)scrX0 / (float)this.pg.width - 1.0f;
            this.texCoords[9] = 2.0f * (float)scrY1 / (float)this.pg.height - 1.0f;
            this.texCoords[10] = (float)texX0 / (float)width;
            this.texCoords[11] = (float)texY1 / (float)height;
            this.texCoords[12] = 2.0f * (float)scrX1 / (float)this.pg.width - 1.0f;
            this.texCoords[13] = 2.0f * (float)scrY1 / (float)this.pg.height - 1.0f;
            this.texCoords[14] = (float)texX1 / (float)width;
            this.texCoords[15] = (float)texY1 / (float)height;
            this.texData.rewind();
            this.texData.put(this.texCoords);
            this.glActiveTexture(33984);
            boolean enabledTex = false;
            if (!this.texturingIsEnabled(3553)) {
                this.enableTexturing(3553);
                enabledTex = true;
            }
            this.glBindTexture(3553, id);
            this.glBindBuffer(34962, 0);
            this.texData.position(0);
            this.glVertexAttribPointer(this.tex2DVertLoc, 2, 5126, false, 16, this.texData);
            this.texData.position(2);
            this.glVertexAttribPointer(this.tex2DTCoordLoc, 2, 5126, false, 16, this.texData);
            this.glDrawArrays(5, 0, 4);
            this.glBindTexture(3553, 0);
            if (enabledTex) {
                this.disableTexturing(3553);
            }
            this.glDisableVertexAttribArray(this.tex2DVertLoc);
            this.glDisableVertexAttribArray(this.tex2DTCoordLoc);
            this.glUseProgram(0);
            if (depthTest[0]) {
                this.glEnable(2929);
            } else {
                this.glDisable(2929);
            }
            this.glDepthMask(depthMask[0]);
        }
    }

    public void drawTextureRect(int id, int width, int height, int texX0, int texY0, int texX1, int texY1, int scrX0, int scrY0, int scrX1, int scrY1) {
        if (!this.loadedTexRectShader || this.texRectShaderContext.hashCode() != this.context.hashCode()) {
            this.texRectVertShader = this.createShader(35633, this.texVertShaderSource);
            this.texRectFragShader = this.createShader(35632, this.texRectFragShaderSource);
            if (this.texRectVertShader > 0 && this.texRectFragShader > 0) {
                this.texRectShaderProgram = this.createProgram(this.texRectVertShader, this.texRectFragShader);
            }
            if (this.texRectShaderProgram > 0) {
                this.texRectVertLoc = this.glGetAttribLocation(this.texRectShaderProgram, "inVertex");
                this.texRectTCoordLoc = this.glGetAttribLocation(this.texRectShaderProgram, "inTexcoord");
            }
            this.loadedTexRectShader = true;
            this.texRectShaderContext = this.context;
        }
        if (this.texData == null) {
            this.texData = PGL.allocateDirectFloatBuffer(this.texCoords.length);
        }
        if (this.texRectShaderProgram > 0) {
            boolean[] depthTest = new boolean[1];
            this.glGetBooleanv(2929, depthTest, 0);
            this.glDisable(2929);
            boolean[] depthMask = new boolean[1];
            this.glGetBooleanv(2930, depthMask, 0);
            this.glDepthMask(false);
            this.glUseProgram(this.texRectShaderProgram);
            this.glEnableVertexAttribArray(this.texRectVertLoc);
            this.glEnableVertexAttribArray(this.texRectTCoordLoc);
            this.texCoords[0] = 2.0f * (float)scrX0 / (float)this.pg.width - 1.0f;
            this.texCoords[1] = 2.0f * (float)scrY0 / (float)this.pg.height - 1.0f;
            this.texCoords[2] = texX0;
            this.texCoords[3] = texY0;
            this.texCoords[4] = 2.0f * (float)scrX1 / (float)this.pg.width - 1.0f;
            this.texCoords[5] = 2.0f * (float)scrY0 / (float)this.pg.height - 1.0f;
            this.texCoords[6] = texX1;
            this.texCoords[7] = texY0;
            this.texCoords[8] = 2.0f * (float)scrX0 / (float)this.pg.width - 1.0f;
            this.texCoords[9] = 2.0f * (float)scrY1 / (float)this.pg.height - 1.0f;
            this.texCoords[10] = texX0;
            this.texCoords[11] = texY1;
            this.texCoords[12] = 2.0f * (float)scrX1 / (float)this.pg.width - 1.0f;
            this.texCoords[13] = 2.0f * (float)scrY1 / (float)this.pg.height - 1.0f;
            this.texCoords[14] = texX1;
            this.texCoords[15] = texY1;
            this.texData.rewind();
            this.texData.put(this.texCoords);
            this.glActiveTexture(33984);
            boolean enabledTex = false;
            if (!this.texturingIsEnabled(34037)) {
                this.enableTexturing(34037);
                enabledTex = true;
            }
            this.glBindTexture(34037, id);
            this.glBindBuffer(34962, 0);
            this.texData.position(0);
            this.glVertexAttribPointer(this.texRectVertLoc, 2, 5126, false, 16, this.texData);
            this.texData.position(2);
            this.glVertexAttribPointer(this.texRectTCoordLoc, 2, 5126, false, 16, this.texData);
            this.glDrawArrays(5, 0, 4);
            this.glBindTexture(34037, 0);
            if (enabledTex) {
                this.disableTexturing(34037);
            }
            this.glDisableVertexAttribArray(this.texRectVertLoc);
            this.glDisableVertexAttribArray(this.texRectTCoordLoc);
            this.glUseProgram(0);
            if (depthTest[0]) {
                this.glEnable(2929);
            } else {
                this.glDisable(2929);
            }
            this.glDepthMask(depthMask[0]);
        }
    }

    public void drawRectangle(float r, float g, float b, float a, int scrX0, int scrY0, int scrX1, int scrY1) {
        if (!this.loadedRectShader || this.rectShaderContext.hashCode() != this.context.hashCode()) {
            this.rectVertShader = this.createShader(35633, this.rectVertShaderSource);
            this.rectFragShader = this.createShader(35632, this.rectFragShaderSource);
            if (this.rectVertShader > 0 && this.rectFragShader > 0) {
                this.rectShaderProgram = this.createProgram(this.rectVertShader, this.rectFragShader);
            }
            if (this.rectShaderProgram > 0) {
                this.rectVertLoc = this.glGetAttribLocation(this.rectShaderProgram, "inVertex");
                this.rectColorLoc = this.glGetUniformLocation(this.rectShaderProgram, "rectColor");
            }
            this.rectData = PGL.allocateDirectFloatBuffer(this.rectCoords.length);
            this.loadedRectShader = true;
            this.rectShaderContext = this.context;
        }
        if (this.rectShaderProgram > 0) {
            boolean[] depthTest = new boolean[1];
            this.glGetBooleanv(2929, depthTest, 0);
            this.glDisable(2929);
            boolean[] depthMask = new boolean[1];
            this.glGetBooleanv(2930, depthMask, 0);
            this.glDepthMask(false);
            this.glUseProgram(this.rectShaderProgram);
            this.glEnableVertexAttribArray(this.rectVertLoc);
            this.glUniform4f(this.rectColorLoc, r, g, b, a);
            this.rectCoords[0] = 2.0f * (float)scrX0 / (float)this.pg.width - 1.0f;
            this.rectCoords[1] = 2.0f * (float)scrY0 / (float)this.pg.height - 1.0f;
            this.rectCoords[2] = 2.0f * (float)scrX1 / (float)this.pg.width - 1.0f;
            this.rectCoords[3] = 2.0f * (float)scrY0 / (float)this.pg.height - 1.0f;
            this.rectCoords[4] = 2.0f * (float)scrX0 / (float)this.pg.width - 1.0f;
            this.rectCoords[5] = 2.0f * (float)scrY1 / (float)this.pg.height - 1.0f;
            this.rectCoords[6] = 2.0f * (float)scrX1 / (float)this.pg.width - 1.0f;
            this.rectCoords[7] = 2.0f * (float)scrY1 / (float)this.pg.height - 1.0f;
            this.rectData.rewind();
            this.rectData.put(this.rectCoords);
            this.glBindBuffer(34962, 0);
            this.rectData.position(0);
            this.glVertexAttribPointer(this.rectVertLoc, 2, 5126, false, 8, this.rectData);
            this.glDrawArrays(5, 0, 4);
            this.glDisableVertexAttribArray(this.rectVertLoc);
            this.glUseProgram(0);
            if (depthTest[0]) {
                this.glEnable(2929);
            } else {
                this.glDisable(2929);
            }
            this.glDepthMask(depthMask[0]);
        }
    }

    public int getColorValue(int scrX, int scrY) {
        if (this.colorBuffer == null) {
            this.colorBuffer = IntBuffer.allocate(1);
        }
        this.colorBuffer.rewind();
        this.glReadPixels(scrX, this.pg.height - scrY - 1, 1, 1, 6408, 5121, this.colorBuffer);
        return this.colorBuffer.get();
    }

    public float getDepthValue(int scrX, int scrY) {
        if (this.depthBuffer == null) {
            this.depthBuffer = FloatBuffer.allocate(1);
        }
        this.depthBuffer.rewind();
        this.glReadPixels(scrX, this.pg.height - scrY - 1, 1, 1, 6402, 5126, this.depthBuffer);
        return this.depthBuffer.get(0);
    }

    public byte getStencilValue(int scrX, int scrY) {
        if (this.stencilBuffer == null) {
            this.stencilBuffer = ByteBuffer.allocate(1);
        }
        this.glReadPixels(scrX, this.pg.height - scrY - 1, 1, 1, 6401, 5121, this.stencilBuffer);
        return this.stencilBuffer.get(0);
    }

    public static int nextPowerOfTwo(int val) {
        int ret = 1;
        while (ret < val) {
            ret <<= 1;
        }
        return ret;
    }

    public static int nativeToJavaARGB(int color) {
        if (BIG_ENDIAN) {
            return color & 0xFF000000 | color >> 8 & 0xFFFFFF;
        }
        return color & 0xFF000000 | color << 16 & 0xFF0000 | color & 0xFF00 | color >> 16 & 0xFF;
    }

    public static void nativeToJavaARGB(int[] pixels, int width, int height) {
        block9: {
            int x;
            int index = 0;
            int yindex = (height - 1) * width;
            int y = 0;
            while (y < height / 2) {
                int temp;
                int x2;
                if (BIG_ENDIAN) {
                    x2 = 0;
                    while (x2 < width) {
                        temp = pixels[index];
                        pixels[index] = pixels[yindex] & 0xFF000000 | pixels[yindex] >> 8 & 0xFFFFFF;
                        pixels[yindex] = temp & 0xFF000000 | temp >> 8 & 0xFFFFFF;
                        ++index;
                        ++yindex;
                        ++x2;
                    }
                } else {
                    x2 = 0;
                    while (x2 < width) {
                        temp = pixels[index];
                        pixels[index] = pixels[yindex] & 0xFF000000 | pixels[yindex] << 16 & 0xFF0000 | pixels[yindex] & 0xFF00 | pixels[yindex] >> 16 & 0xFF;
                        pixels[yindex] = temp & 0xFF000000 | temp << 16 & 0xFF0000 | temp & 0xFF00 | temp >> 16 & 0xFF;
                        ++index;
                        ++yindex;
                        ++x2;
                    }
                }
                yindex -= width * 2;
                ++y;
            }
            if (height % 2 != 1) break block9;
            index = height / 2 * width;
            if (BIG_ENDIAN) {
                x = 0;
                while (x < width) {
                    pixels[index] = pixels[index] & 0xFF000000 | pixels[index] >> 8 & 0xFFFFFF;
                    ++index;
                    ++x;
                }
            } else {
                x = 0;
                while (x < width) {
                    pixels[index] = pixels[index] & 0xFF000000 | pixels[index] << 16 & 0xFF0000 | pixels[index] & 0xFF00 | pixels[index] >> 16 & 0xFF;
                    ++index;
                    ++x;
                }
            }
        }
    }

    public static int nativeToJavaRGB(int color) {
        if (BIG_ENDIAN) {
            return color << 8 & 0xFFFFFF00 | 0xFF;
        }
        return 0xFF000000 | color << 16 & 0xFF0000 | color & 0xFF00 | color >> 16 & 0xFF;
    }

    public static void nativeToJavaRGB(int[] pixels, int width, int height) {
        block9: {
            int x;
            int index = 0;
            int yindex = (height - 1) * width;
            int y = 0;
            while (y < height / 2) {
                int temp;
                int x2;
                if (BIG_ENDIAN) {
                    x2 = 0;
                    while (x2 < width) {
                        temp = pixels[index];
                        pixels[index] = 0xFF000000 | pixels[yindex] >> 8 & 0xFFFFFF;
                        pixels[yindex] = 0xFF000000 | temp >> 8 & 0xFFFFFF;
                        ++index;
                        ++yindex;
                        ++x2;
                    }
                } else {
                    x2 = 0;
                    while (x2 < width) {
                        temp = pixels[index];
                        pixels[index] = 0xFF000000 | pixels[yindex] << 16 & 0xFF0000 | pixels[yindex] & 0xFF00 | pixels[yindex] >> 16 & 0xFF;
                        pixels[yindex] = 0xFF000000 | temp << 16 & 0xFF0000 | temp & 0xFF00 | temp >> 16 & 0xFF;
                        ++index;
                        ++yindex;
                        ++x2;
                    }
                }
                yindex -= width * 2;
                ++y;
            }
            if (height % 2 != 1) break block9;
            index = height / 2 * width;
            if (BIG_ENDIAN) {
                x = 0;
                while (x < width) {
                    pixels[index] = 0xFF000000 | pixels[index] >> 8 & 0xFFFFFF;
                    ++index;
                    ++x;
                }
            } else {
                x = 0;
                while (x < width) {
                    pixels[index] = 0xFF000000 | pixels[index] << 16 & 0xFF0000 | pixels[index] & 0xFF00 | pixels[index] >> 16 & 0xFF;
                    ++index;
                    ++x;
                }
            }
        }
    }

    public static int javaToNativeARGB(int color) {
        if (BIG_ENDIAN) {
            return color >> 24 & 0xFF | color << 8 & 0xFFFFFF00;
        }
        return color & 0xFF000000 | color << 16 & 0xFF0000 | color & 0xFF00 | color >> 16 & 0xFF;
    }

    public static void javaToNativeARGB(int[] pixels, int width, int height) {
        block9: {
            int x;
            int index = 0;
            int yindex = (height - 1) * width;
            int y = 0;
            while (y < height / 2) {
                int temp;
                int x2;
                if (BIG_ENDIAN) {
                    x2 = 0;
                    while (x2 < width) {
                        temp = pixels[index];
                        pixels[index] = pixels[yindex] >> 24 & 0xFF | pixels[yindex] << 8 & 0xFFFFFF00;
                        pixels[yindex] = temp >> 24 & 0xFF | temp << 8 & 0xFFFFFF00;
                        ++index;
                        ++yindex;
                        ++x2;
                    }
                } else {
                    x2 = 0;
                    while (x2 < width) {
                        temp = pixels[index];
                        pixels[index] = pixels[yindex] & 0xFF000000 | pixels[yindex] << 16 & 0xFF0000 | pixels[yindex] & 0xFF00 | pixels[yindex] >> 16 & 0xFF;
                        pixels[yindex] = pixels[yindex] & 0xFF000000 | temp << 16 & 0xFF0000 | temp & 0xFF00 | temp >> 16 & 0xFF;
                        ++index;
                        ++yindex;
                        ++x2;
                    }
                }
                yindex -= width * 2;
                ++y;
            }
            if (height % 2 != 1) break block9;
            index = height / 2 * width;
            if (BIG_ENDIAN) {
                x = 0;
                while (x < width) {
                    pixels[index] = pixels[index] >> 24 & 0xFF | pixels[index] << 8 & 0xFFFFFF00;
                    ++index;
                    ++x;
                }
            } else {
                x = 0;
                while (x < width) {
                    pixels[index] = pixels[index] & 0xFF000000 | pixels[index] << 16 & 0xFF0000 | pixels[index] & 0xFF00 | pixels[index] >> 16 & 0xFF;
                    ++index;
                    ++x;
                }
            }
        }
    }

    public static int javaToNativeRGB(int color) {
        if (BIG_ENDIAN) {
            return color << 8 & 0xFFFFFF00 | 0xFF;
        }
        return 0xFF000000 | color << 16 & 0xFF0000 | color & 0xFF00 | color >> 16 & 0xFF;
    }

    public static void javaToNativeRGB(int[] pixels, int width, int height) {
        block9: {
            int x;
            int index = 0;
            int yindex = (height - 1) * width;
            int y = 0;
            while (y < height / 2) {
                int temp;
                int x2;
                if (BIG_ENDIAN) {
                    x2 = 0;
                    while (x2 < width) {
                        temp = pixels[index];
                        pixels[index] = pixels[yindex] << 8 & 0xFFFFFF00 | 0xFF;
                        pixels[yindex] = temp << 8 & 0xFFFFFF00 | 0xFF;
                        ++index;
                        ++yindex;
                        ++x2;
                    }
                } else {
                    x2 = 0;
                    while (x2 < width) {
                        temp = pixels[index];
                        pixels[index] = 0xFF000000 | pixels[yindex] << 16 & 0xFF0000 | pixels[yindex] & 0xFF00 | pixels[yindex] >> 16 & 0xFF;
                        pixels[yindex] = 0xFF000000 | temp << 16 & 0xFF0000 | temp & 0xFF00 | temp >> 16 & 0xFF;
                        ++index;
                        ++yindex;
                        ++x2;
                    }
                }
                yindex -= width * 2;
                ++y;
            }
            if (height % 2 != 1) break block9;
            index = height / 2 * width;
            if (BIG_ENDIAN) {
                x = 0;
                while (x < width) {
                    pixels[index] = pixels[index] << 8 & 0xFFFFFF00 | 0xFF;
                    ++index;
                    ++x;
                }
            } else {
                x = 0;
                while (x < width) {
                    pixels[index] = 0xFF000000 | pixels[index] << 16 & 0xFF0000 | pixels[index] & 0xFF00 | pixels[index] >> 16 & 0xFF;
                    ++index;
                    ++x;
                }
            }
        }
    }

    public int createShader(int shaderType, String source) {
        int shader = this.glCreateShader(shaderType);
        if (shader != 0) {
            this.glShaderSource(shader, source);
            this.glCompileShader(shader);
            int[] compiled = new int[1];
            this.glGetShaderiv(shader, 35713, compiled, 0);
            if (compiled[0] == 0) {
                System.err.println("Could not compile shader " + shaderType + ":");
                System.err.println(this.glGetShaderInfoLog(shader));
                this.glDeleteShader(shader);
                shader = 0;
            }
        }
        return shader;
    }

    public int createProgram(int vertexShader, int fragmentShader) {
        int program = this.glCreateProgram();
        if (program != 0) {
            this.glAttachShader(program, vertexShader);
            this.glAttachShader(program, fragmentShader);
            this.glLinkProgram(program);
            int[] linked = new int[1];
            this.glGetProgramiv(program, 35714, linked, 0);
            if (linked[0] == 0) {
                System.err.println("Could not link program: ");
                System.err.println(this.glGetProgramInfoLog(program));
                this.glDeleteProgram(program);
                program = 0;
            }
        }
        return program;
    }

    public boolean validateFramebuffer() {
        int status = this.glCheckFramebufferStatus(36160);
        if (status == 36053) {
            return true;
        }
        if (status == 36054) {
            throw new RuntimeException("PFramebuffer: GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT (" + Integer.toHexString(status) + ")");
        }
        if (status == 36055) {
            throw new RuntimeException("PFramebuffer: GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT (" + Integer.toHexString(status) + ")");
        }
        if (status == 36057) {
            throw new RuntimeException("PFramebuffer: GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS (" + Integer.toHexString(status) + ")");
        }
        if (status == 36058) {
            throw new RuntimeException("PFramebuffer: GL_FRAMEBUFFER_INCOMPLETE_FORMATS (" + Integer.toHexString(status) + ")");
        }
        if (status == 36061) {
            throw new RuntimeException("PFramebuffer: GL_FRAMEBUFFER_UNSUPPORTED" + Integer.toHexString(status));
        }
        throw new RuntimeException("PFramebuffer: unknown framebuffer error (" + Integer.toHexString(status) + ")");
    }

    public static ByteBuffer allocateDirectByteBuffer(int size) {
        return ByteBuffer.allocateDirect(size * 1).order(ByteOrder.nativeOrder());
    }

    public static IntBuffer allocateDirectIntBuffer(int size) {
        return ByteBuffer.allocateDirect(size * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
    }

    public static FloatBuffer allocateDirectFloatBuffer(int size) {
        return ByteBuffer.allocateDirect(size * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
    }

    public class Context {
        protected GLContext glContext;

        Context() {
            this.glContext = null;
        }

        Context(GLContext context) {
            this.glContext = context;
        }

        boolean current() {
            return this.equal(PGL.this.context);
        }

        boolean equal(GLContext context) {
            if (this.glContext == null || context == null) {
                return true;
            }
            return this.glContext.hashCode() == context.hashCode();
        }

        int code() {
            if (this.glContext == null) {
                return -1;
            }
            return this.glContext.hashCode();
        }
    }

    protected static class PGLAnimator
    extends AnimatorBase {
        private static int count = 0;
        private Timer timer = null;
        private TimerTask task = null;
        private volatile boolean shouldRun;

        protected String getBaseName(String prefix) {
            return String.valueOf(prefix) + "PGLAnimator";
        }

        public PGLAnimator(GLAutoDrawable drawable) {
            if (drawable != null) {
                this.add(drawable);
            }
        }

        public synchronized void requestDisplay() {
            this.shouldRun = true;
        }

        public final boolean isStarted() {
            this.stateSync.lock();
            try {
                boolean bl = this.timer != null;
                return bl;
            }
            finally {
                this.stateSync.unlock();
            }
        }

        public final boolean isAnimating() {
            this.stateSync.lock();
            try {
                boolean bl = this.timer != null && this.task != null;
                return bl;
            }
            finally {
                this.stateSync.unlock();
            }
        }

        private void startTask() {
            if (this.task != null) {
                return;
            }
            this.task = new TimerTask(){
                private boolean firstRun = true;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (this.firstRun) {
                        Thread.currentThread().setName("PGL-RenderQueue-" + count);
                        this.firstRun = false;
                        count = count + 1;
                    }
                    if (PGLAnimator.this.shouldRun) {
                        PGLAnimator.this.animThread = Thread.currentThread();
                        PGLAnimator.this.display();
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            PGLAnimator.this.shouldRun = false;
                        }
                    }
                }
            };
            this.fpsCounter.resetFPSCounter();
            this.shouldRun = false;
            this.timer.schedule(this.task, 0L, 1L);
        }

        public synchronized boolean start() {
            if (this.timer != null) {
                return false;
            }
            this.stateSync.lock();
            try {
                this.timer = new Timer();
                this.startTask();
            }
            finally {
                this.stateSync.unlock();
            }
            return true;
        }

        public synchronized boolean stop() {
            if (this.timer == null) {
                return false;
            }
            this.stateSync.lock();
            try {
                this.shouldRun = false;
                if (this.task != null) {
                    this.task.cancel();
                    this.task = null;
                }
                if (this.timer != null) {
                    this.timer.cancel();
                    this.timer = null;
                }
                this.animThread = null;
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {}
            }
            finally {
                this.stateSync.unlock();
            }
            return true;
        }

        public final boolean isPaused() {
            return false;
        }

        public synchronized boolean resume() {
            return false;
        }

        public synchronized boolean pause() {
            return false;
        }
    }

    protected class PGLListener
    implements GLEventListener {
        protected PGLListener() {
        }

        public void display(GLAutoDrawable adrawable) {
            PGL.this.drawable = adrawable;
            PGL.this.context = adrawable.getContext();
            PGL.this.gl = PGL.this.context.getGL();
            PGL.this.gl2 = PGL.this.gl.getGL2ES2();
            try {
                PGL.this.gl2x = PGL.this.gl.getGL2();
            }
            catch (GLException e) {
                PGL.this.gl2x = null;
            }
            PGL.this.pg.parent.handleDraw();
        }

        public void dispose(GLAutoDrawable adrawable) {
        }

        public void init(GLAutoDrawable adrawable) {
            PGL.this.drawable = adrawable;
            PGL.this.context = adrawable.getContext();
        }

        public void reshape(GLAutoDrawable adrawable, int x, int y, int w, int h) {
            PGL.this.drawable = adrawable;
            PGL.this.context = adrawable.getContext();
            if (PGL.this.glColorFbo[0] != 0) {
                PGL.this.glColorFbo[0] = 0;
            }
        }
    }

    public class Tessellator {
        protected GLUtessellator tess;
        protected TessellatorCallback callback;
        protected GLUCallback gluCallback;

        public Tessellator(TessellatorCallback callback) {
            this.callback = callback;
            this.tess = GLU.gluNewTess();
            this.gluCallback = new GLUCallback();
            GLU.gluTessCallback((GLUtessellator)this.tess, (int)100100, (GLUtessellatorCallback)this.gluCallback);
            GLU.gluTessCallback((GLUtessellator)this.tess, (int)100102, (GLUtessellatorCallback)this.gluCallback);
            GLU.gluTessCallback((GLUtessellator)this.tess, (int)100101, (GLUtessellatorCallback)this.gluCallback);
            GLU.gluTessCallback((GLUtessellator)this.tess, (int)100105, (GLUtessellatorCallback)this.gluCallback);
            GLU.gluTessCallback((GLUtessellator)this.tess, (int)100103, (GLUtessellatorCallback)this.gluCallback);
        }

        public void beginPolygon() {
            GLU.gluTessBeginPolygon((GLUtessellator)this.tess, null);
        }

        public void endPolygon() {
            GLU.gluTessEndPolygon((GLUtessellator)this.tess);
        }

        public void setWindingRule(int rule) {
            GLU.gluTessProperty((GLUtessellator)this.tess, (int)100140, (double)rule);
        }

        public void beginContour() {
            GLU.gluTessBeginContour((GLUtessellator)this.tess);
        }

        public void endContour() {
            GLU.gluTessEndContour((GLUtessellator)this.tess);
        }

        public void addVertex(double[] v) {
            GLU.gluTessVertex((GLUtessellator)this.tess, (double[])v, (int)0, (Object)v);
        }

        protected class GLUCallback
        extends GLUtessellatorCallbackAdapter {
            protected GLUCallback() {
            }

            public void begin(int type) {
                Tessellator.this.callback.begin(type);
            }

            public void end() {
                Tessellator.this.callback.end();
            }

            public void vertex(Object data) {
                Tessellator.this.callback.vertex(data);
            }

            public void combine(double[] coords, Object[] data, float[] weight, Object[] outData) {
                Tessellator.this.callback.combine(coords, data, weight, outData);
            }

            public void error(int errnum) {
                Tessellator.this.callback.error(errnum);
            }
        }
    }

    public static interface TessellatorCallback {
        public void begin(int var1);

        public void end();

        public void vertex(Object var1);

        public void combine(double[] var1, Object[] var2, float[] var3, Object[] var4);

        public void error(int var1);
    }
}

