/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Hashtable;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PShape;
import processing.core.PVector;
import processing.opengl.PGraphicsOpenGL;
import processing.opengl.PShape3D;

public class PGraphics3D
extends PGraphicsOpenGL {
    @Override
    public boolean is2D() {
        return false;
    }

    @Override
    public boolean is3D() {
        return true;
    }

    @Override
    protected void defaultPerspective() {
        this.perspective();
    }

    @Override
    protected void defaultCamera() {
        this.camera();
    }

    @Override
    protected void begin2D() {
        this.pushProjection();
        this.ortho(-this.width / 2, this.width / 2, -this.height / 2, this.height / 2, -1.0f, 1.0f);
        this.pushMatrix();
        this.camera(this.width / 2, this.height / 2);
    }

    @Override
    protected void end2D() {
        this.popMatrix();
        this.popProjection();
    }

    protected static boolean isSupportedExtension(String extension) {
        return extension.equals("obj");
    }

    protected static PShape loadShapeImpl(PGraphics pg, String filename, String ext) {
        ArrayList<PVector> vertices = new ArrayList<PVector>();
        ArrayList<PVector> normals = new ArrayList<PVector>();
        ArrayList<PVector> textures = new ArrayList<PVector>();
        ArrayList<OBJFace> faces = new ArrayList<OBJFace>();
        ArrayList<OBJMaterial> materials = new ArrayList<OBJMaterial>();
        BufferedReader reader = pg.parent.createReader(filename);
        PGraphics3D.parseOBJ(pg.parent, reader, vertices, normals, textures, faces, materials);
        int prevColorMode = pg.colorMode;
        float prevColorModeX = pg.colorModeX;
        float prevColorModeY = pg.colorModeY;
        float prevColorModeZ = pg.colorModeZ;
        float prevColorModeA = pg.colorModeA;
        boolean prevStroke = pg.stroke;
        int prevTextureMode = pg.textureMode;
        pg.colorMode(1, 1.0f);
        pg.stroke = false;
        pg.textureMode = 1;
        PShape3D root = PGraphics3D.createShapeImpl(pg.parent, 0);
        int mtlIdxCur = -1;
        OBJMaterial mtl = null;
        int i = 0;
        while (i < faces.size()) {
            OBJFace face = faces.get(i);
            if (mtlIdxCur != face.matIdx) {
                mtlIdxCur = PApplet.max(0, face.matIdx);
                mtl = materials.get(mtlIdxCur);
            }
            PShape3D child = face.vertIdx.size() == 3 ? PGraphics3D.createShapeImpl(pg.parent, 9) : (face.vertIdx.size() == 4 ? PGraphics3D.createShapeImpl(pg.parent, 17) : PGraphics3D.createShapeImpl(pg.parent, 20));
            ((PShape)child).fill(mtl.kd.x, mtl.kd.y, mtl.kd.z);
            ((PShape)child).ambient(mtl.ka.x, mtl.ka.y, mtl.ka.z);
            ((PShape)child).specular(mtl.ks.x, mtl.ks.y, mtl.ks.z);
            ((PShape)child).shininess(mtl.ns);
            if (mtl.kdMap != null) {
                ((PShape)child).tint(mtl.kd.x, mtl.kd.y, mtl.kd.z, mtl.d);
            }
            int j = 0;
            while (j < face.vertIdx.size()) {
                int normIdx;
                PVector norms = null;
                PVector vert = null;
                int vertIdx = face.vertIdx.get(j) - 1;
                vert = vertices.get(vertIdx);
                if (j < face.normIdx.size() && -1 < (normIdx = face.normIdx.get(j) - 1)) {
                    norms = normals.get(normIdx);
                }
                if (mtl != null && mtl.kdMap != null) {
                    int texIdx;
                    PVector tex = null;
                    if (j < face.texIdx.size() && -1 < (texIdx = face.texIdx.get(j) - 1)) {
                        tex = textures.get(texIdx);
                    }
                    ((PShape)child).texture(mtl.kdMap);
                    if (norms != null) {
                        ((PShape)child).normal(norms.x, norms.y, norms.z);
                    }
                    if (tex != null) {
                        ((PShape)child).vertex(vert.x, vert.y, vert.z, tex.x, tex.y);
                    } else {
                        ((PShape)child).vertex(vert.x, vert.y, vert.z);
                    }
                } else {
                    if (norms != null) {
                        ((PShape)child).normal(norms.x, norms.y, norms.z);
                    }
                    ((PShape)child).vertex(vert.x, vert.y, vert.z);
                }
                ++j;
            }
            ((PShape)child).end(2);
            ((PShape)root).addChild(child);
            ++i;
        }
        pg.colorMode(prevColorMode, prevColorModeX, prevColorModeY, prevColorModeZ, prevColorModeA);
        pg.stroke = prevStroke;
        pg.textureMode = prevTextureMode;
        return root;
    }

    @Override
    public PShape createShape(PShape source) {
        return PShape3D.createShape(this.parent, source);
    }

    @Override
    public PShape createShape() {
        return this.createShape(20);
    }

    @Override
    public PShape createShape(int type) {
        return PGraphics3D.createShapeImpl(this.parent, type);
    }

    @Override
    public PShape createShape(int kind, float ... p) {
        return PGraphics3D.createShapeImpl(this.parent, kind, p);
    }

    protected static PShape3D createShapeImpl(PApplet parent, int type) {
        PShape3D shape = null;
        if (type == 0) {
            shape = new PShape3D(parent, 0);
        } else if (type == 2) {
            shape = new PShape3D(parent, 2);
        } else if (type == 3) {
            shape = new PShape3D(parent, 3);
            shape.setKind(3);
        } else if (type == 5) {
            shape = new PShape3D(parent, 3);
            shape.setKind(5);
        } else if (type == 8 || type == 9) {
            shape = new PShape3D(parent, 3);
            shape.setKind(9);
        } else if (type == 11) {
            shape = new PShape3D(parent, 3);
            shape.setKind(11);
        } else if (type == 10) {
            shape = new PShape3D(parent, 3);
            shape.setKind(10);
        } else if (type == 16 || type == 17) {
            shape = new PShape3D(parent, 3);
            shape.setKind(17);
        } else if (type == 18) {
            shape = new PShape3D(parent, 3);
            shape.setKind(18);
        } else if (type == 20) {
            shape = new PShape3D(parent, 3);
            shape.setKind(20);
        }
        return shape;
    }

    protected static PShape3D createShapeImpl(PApplet parent, int kind, float ... p) {
        PShape3D shape = null;
        int len = p.length;
        if (kind == 2) {
            if (len != 2 && len != 3) {
                PGraphics3D.showWarning("Wrong number of parameters");
                return null;
            }
            shape = new PShape3D(parent, 1);
            shape.setKind(2);
        } else if (kind == 4) {
            if (len != 4 && len != 6) {
                PGraphics3D.showWarning("Wrong number of parameters");
                return null;
            }
            shape = new PShape3D(parent, 1);
            shape.setKind(4);
        } else if (kind == 8) {
            if (len != 6) {
                PGraphics3D.showWarning("Wrong number of parameters");
                return null;
            }
            shape = new PShape3D(parent, 1);
            shape.setKind(8);
        } else if (kind == 16) {
            if (len != 8) {
                PGraphics3D.showWarning("Wrong number of parameters");
                return null;
            }
            shape = new PShape3D(parent, 1);
            shape.setKind(16);
        } else if (kind == 30) {
            if (len != 4 && len != 5 && len != 8) {
                PGraphics3D.showWarning("Wrong number of parameters");
                return null;
            }
            shape = new PShape3D(parent, 1);
            shape.setKind(30);
        } else if (kind == 31) {
            if (len != 4) {
                PGraphics3D.showWarning("Wrong number of parameters");
                return null;
            }
            shape = new PShape3D(parent, 1);
            shape.setKind(31);
        } else if (kind == 32) {
            if (len != 6) {
                PGraphics3D.showWarning("Wrong number of parameters");
                return null;
            }
            shape = new PShape3D(parent, 1);
            shape.setKind(32);
        } else if (kind == 41) {
            if (len != 1 && len != 3) {
                PGraphics3D.showWarning("Wrong number of parameters");
                return null;
            }
            shape = new PShape3D(parent, 1);
            shape.setKind(41);
        } else if (kind == 40) {
            if (len != 1) {
                PGraphics3D.showWarning("Wrong number of parameters");
                return null;
            }
            shape = new PShape3D(parent, 1);
            shape.setKind(40);
        } else {
            PGraphics3D.showWarning("Unrecognized primitive type");
        }
        if (shape != null) {
            shape.setParams(p);
        }
        return shape;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void parseOBJ(PApplet parent, BufferedReader reader, ArrayList<PVector> vertices, ArrayList<PVector> normals, ArrayList<PVector> textures, ArrayList<OBJFace> faces, ArrayList<OBJMaterial> materials) {
        Hashtable<String, Integer> mtlTable = new Hashtable<String, Integer>();
        int mtlIdxCur = -1;
        try {
            boolean readvt = false;
            boolean readvn = false;
            boolean readv = false;
            String gname = "object";
            block2: while (true) {
                PVector tempv;
                String[] elements;
                String line;
                if ((line = reader.readLine()) == null) {
                    if (materials.size() != 0) return;
                    OBJMaterial defMtl = new OBJMaterial();
                    materials.add(defMtl);
                    return;
                }
                while (true) {
                    if (!line.contains("\\")) {
                        elements = line.split("\\s+");
                        if (elements.length <= 0) continue block2;
                        if (!elements[0].equals("v")) break;
                        tempv = new PVector(Float.valueOf(elements[1]).floatValue(), Float.valueOf(elements[2]).floatValue(), Float.valueOf(elements[3]).floatValue());
                        vertices.add(tempv);
                        readv = true;
                        continue block2;
                    }
                    line = line.split("\\\\")[0];
                    String s = reader.readLine();
                    if (s == null) continue;
                    line = String.valueOf(line) + s;
                }
                if (elements[0].equals("vn")) {
                    PVector tempn = new PVector(Float.valueOf(elements[1]).floatValue(), Float.valueOf(elements[2]).floatValue(), Float.valueOf(elements[3]).floatValue());
                    normals.add(tempn);
                    readvn = true;
                    continue;
                }
                if (elements[0].equals("vt")) {
                    tempv = new PVector(Float.valueOf(elements[1]).floatValue(), 1.0f - Float.valueOf(elements[2]).floatValue());
                    textures.add(tempv);
                    readvt = true;
                    continue;
                }
                if (elements[0].equals("o")) continue;
                if (elements[0].equals("mtllib")) {
                    BufferedReader mreader;
                    if (elements[1] == null || (mreader = parent.createReader(elements[1])) == null) continue;
                    PGraphics3D.parseMTL(parent, mreader, materials, mtlTable);
                    continue;
                }
                if (elements[0].equals("g")) {
                    gname = 1 < elements.length ? elements[1] : "";
                    continue;
                }
                if (elements[0].equals("usemtl")) {
                    if (elements[1] == null) continue;
                    String mtlname = elements[1];
                    if (mtlTable.containsKey(mtlname)) {
                        Integer tempInt = mtlTable.get(mtlname);
                        mtlIdxCur = tempInt;
                        continue;
                    }
                    mtlIdxCur = -1;
                    continue;
                }
                if (!elements[0].equals("f")) continue;
                OBJFace face = new OBJFace();
                face.matIdx = mtlIdxCur;
                face.name = gname;
                int i = 1;
                while (true) {
                    block26: {
                        String seg;
                        block24: {
                            String[] forder;
                            block27: {
                                block25: {
                                    if (i >= elements.length) {
                                        faces.add(face);
                                        continue block2;
                                    }
                                    seg = elements[i];
                                    if (seg.indexOf("/") <= 0) break block24;
                                    forder = seg.split("/");
                                    if (forder.length <= 2) break block25;
                                    if (forder[0].length() > 0 && readv) {
                                        face.vertIdx.add(Integer.valueOf(forder[0]));
                                    }
                                    if (forder[1].length() > 0 && readvt) {
                                        face.texIdx.add(Integer.valueOf(forder[1]));
                                    }
                                    if (forder[2].length() > 0 && readvn) {
                                        face.normIdx.add(Integer.valueOf(forder[2]));
                                    }
                                    break block26;
                                }
                                if (forder.length <= 1) break block27;
                                if (forder[0].length() > 0 && readv) {
                                    face.vertIdx.add(Integer.valueOf(forder[0]));
                                }
                                if (forder[1].length() > 0) {
                                    if (readvt) {
                                        face.texIdx.add(Integer.valueOf(forder[1]));
                                        break block26;
                                    } else if (readvn) {
                                        face.normIdx.add(Integer.valueOf(forder[1]));
                                    }
                                }
                                break block26;
                            }
                            if (forder.length > 0 && forder[0].length() > 0 && readv) {
                                face.vertIdx.add(Integer.valueOf(forder[0]));
                            }
                            break block26;
                        }
                        if (seg.length() > 0 && readv) {
                            face.vertIdx.add(Integer.valueOf(seg));
                        }
                    }
                    ++i;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void parseMTL(PApplet parent, BufferedReader reader, ArrayList<OBJMaterial> materials, Hashtable<String, Integer> materialsHash) {
        try {
            String line;
            OBJMaterial currentMtl = null;
            while ((line = reader.readLine()) != null) {
                String[] elements = (line = line.trim()).split("\\s+");
                if (elements.length <= 0) continue;
                if (elements[0].equals("newmtl")) {
                    String mtlname = elements[1];
                    currentMtl = new OBJMaterial(mtlname);
                    materialsHash.put(mtlname, new Integer(materials.size()));
                    materials.add(currentMtl);
                    continue;
                }
                if (elements[0].equals("map_Kd") && elements.length > 1) {
                    String texname = elements[1];
                    currentMtl.kdMap = parent.loadImage(texname);
                    continue;
                }
                if (elements[0].equals("Ka") && elements.length > 3) {
                    currentMtl.ka.x = Float.valueOf(elements[1]).floatValue();
                    currentMtl.ka.y = Float.valueOf(elements[2]).floatValue();
                    currentMtl.ka.z = Float.valueOf(elements[3]).floatValue();
                    continue;
                }
                if (elements[0].equals("Kd") && elements.length > 3) {
                    currentMtl.kd.x = Float.valueOf(elements[1]).floatValue();
                    currentMtl.kd.y = Float.valueOf(elements[2]).floatValue();
                    currentMtl.kd.z = Float.valueOf(elements[3]).floatValue();
                    continue;
                }
                if (elements[0].equals("Ks") && elements.length > 3) {
                    currentMtl.ks.x = Float.valueOf(elements[1]).floatValue();
                    currentMtl.ks.y = Float.valueOf(elements[2]).floatValue();
                    currentMtl.ks.z = Float.valueOf(elements[3]).floatValue();
                    continue;
                }
                if ((elements[0].equals("d") || elements[0].equals("Tr")) && elements.length > 1) {
                    currentMtl.d = Float.valueOf(elements[1]).floatValue();
                    continue;
                }
                if (!elements[0].equals("Ns") || elements.length <= 1) continue;
                currentMtl.ns = Float.valueOf(elements[1]).floatValue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static class OBJFace {
        ArrayList<Integer> vertIdx = new ArrayList();
        ArrayList<Integer> texIdx = new ArrayList();
        ArrayList<Integer> normIdx = new ArrayList();
        int matIdx = -1;
        String name = "";

        OBJFace() {
        }
    }

    protected static class OBJMaterial {
        String name;
        PVector ka;
        PVector kd;
        PVector ks;
        float d;
        float ns;
        PImage kdMap;

        OBJMaterial() {
            this("default");
        }

        OBJMaterial(String name) {
            this.name = name;
            this.ka = new PVector(0.5f, 0.5f, 0.5f);
            this.kd = new PVector(0.5f, 0.5f, 0.5f);
            this.ks = new PVector(0.5f, 0.5f, 0.5f);
            this.d = 1.0f;
            this.ns = 0.0f;
            this.kdMap = null;
        }
    }
}

