/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PMatrix2D;
import processing.core.PMatrix3D;
import processing.core.PVector;
import processing.opengl.PGL;
import processing.opengl.PGraphicsOpenGL;

public class PShader {
    public static final int FLAT = 0;
    public static final int LIT = 1;
    public static final int TEXTURED = 2;
    public static final int FULL = 3;
    public static final int LINE = 4;
    public static final int POINT = 5;
    protected PApplet parent;
    protected PGraphicsOpenGL pgMain;
    protected PGraphicsOpenGL pgCurrent;
    protected PGL pgl;
    protected PGL.Context context;
    public int glProgram;
    public int glVertex;
    public int glFragment;
    protected URL vertexURL;
    protected URL fragmentURL;
    protected String vertexFilename;
    protected String fragmentFilename;
    protected String vertexShaderSource;
    protected String fragmentShaderSource;
    protected boolean bound;
    protected HashMap<Integer, UniformValue> uniformValues = null;

    public PShader() {
        this.parent = null;
        this.pgMain = null;
        this.pgl = null;
        this.context = null;
        this.vertexURL = null;
        this.fragmentURL = null;
        this.vertexFilename = null;
        this.fragmentFilename = null;
        this.glProgram = 0;
        this.glVertex = 0;
        this.glFragment = 0;
        this.bound = false;
    }

    public PShader(PApplet parent) {
        this();
        this.parent = parent;
        this.pgMain = (PGraphicsOpenGL)parent.g;
        this.pgl = this.pgMain.pgl;
        this.context = this.pgl.createEmptyContext();
    }

    public PShader(PApplet parent, String vertFilename, String fragFilename) {
        this.parent = parent;
        this.pgMain = (PGraphicsOpenGL)parent.g;
        this.pgl = this.pgMain.pgl;
        this.vertexURL = null;
        this.fragmentURL = null;
        this.vertexFilename = vertFilename;
        this.fragmentFilename = fragFilename;
        this.glProgram = 0;
        this.glVertex = 0;
        this.glFragment = 0;
    }

    public PShader(PApplet parent, URL vertURL, URL fragURL) {
        this.parent = parent;
        this.pgMain = (PGraphicsOpenGL)parent.g;
        this.pgl = this.pgMain.pgl;
        this.vertexURL = vertURL;
        this.fragmentURL = fragURL;
        this.vertexFilename = null;
        this.fragmentFilename = null;
        this.glProgram = 0;
        this.glVertex = 0;
        this.glFragment = 0;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.glVertex != 0) {
                this.pgMain.finalizeGLSLVertShaderObject(this.glVertex, this.context.code());
            }
            if (this.glFragment != 0) {
                this.pgMain.finalizeGLSLFragShaderObject(this.glFragment, this.context.code());
            }
            if (this.glProgram != 0) {
                this.pgMain.finalizeGLSLProgramObject(this.glProgram, this.context.code());
            }
        }
        finally {
            super.finalize();
        }
    }

    public void setVertexShader(String vertFilename) {
        this.vertexFilename = vertFilename;
    }

    public void setVertexShader(URL vertURL) {
        this.vertexURL = vertURL;
    }

    public void setFragmentShader(String fragFilename) {
        this.fragmentFilename = fragFilename;
    }

    public void setFragmentShader(URL fragURL) {
        this.fragmentURL = fragURL;
    }

    public void bind() {
        this.init();
        this.pgl.glUseProgram(this.glProgram);
        this.bound = true;
        this.consumeUniforms();
    }

    public void unbind() {
        this.pgl.glUseProgram(0);
        this.bound = false;
    }

    public boolean bound() {
        return this.bound;
    }

    public void set(String name, int x) {
        this.setUniformImpl(name, 0, new int[]{x});
    }

    public void set(String name, int x, int y) {
        this.setUniformImpl(name, 1, new int[]{x, y});
    }

    public void set(String name, int x, int y, int z) {
        this.setUniformImpl(name, 2, new int[]{x, y, z});
    }

    public void set(String name, int x, int y, int z, int w) {
        this.setUniformImpl(name, 3, new int[]{x, y, z});
    }

    public void set(String name, float x) {
        this.setUniformImpl(name, 4, new float[]{x});
    }

    public void set(String name, float x, float y) {
        this.setUniformImpl(name, 5, new float[]{x, y});
    }

    public void set(String name, float x, float y, float z) {
        this.setUniformImpl(name, 6, new float[]{x, y, z});
    }

    public void set(String name, float x, float y, float z, float w) {
        this.setUniformImpl(name, 7, new float[]{x, y, z, w});
    }

    public void set(String name, PVector vec) {
        this.setUniformImpl(name, 6, new float[]{vec.x, vec.y, vec.z});
    }

    public void set(String name, int[] vec) {
        this.set(name, vec, 1);
    }

    public void set(String name, int[] vec, int ncoords) {
        if (ncoords == 1) {
            this.setUniformImpl(name, 8, vec);
        } else if (ncoords == 2) {
            this.setUniformImpl(name, 9, vec);
        } else if (ncoords == 3) {
            this.setUniformImpl(name, 10, vec);
        } else if (ncoords == 4) {
            this.setUniformImpl(name, 11, vec);
        } else if (4 < ncoords) {
            PGraphics.showWarning("Only up to 4 coordinates per element are supported.");
        } else {
            PGraphics.showWarning("Wrong number of coordinates: it is negative!");
        }
    }

    public void set(String name, float[] vec) {
        this.set(name, vec, 1);
    }

    public void set(String name, float[] vec, int ncoords) {
        if (ncoords == 1) {
            this.setUniformImpl(name, 12, vec);
        } else if (ncoords == 2) {
            this.setUniformImpl(name, 13, vec);
        } else if (ncoords == 3) {
            this.setUniformImpl(name, 14, vec);
        } else if (ncoords == 4) {
            this.setUniformImpl(name, 15, vec);
        } else if (4 < ncoords) {
            PGraphics.showWarning("Only up to 4 coordinates per element are supported.");
        } else {
            PGraphics.showWarning("Wrong number of coordinates: it is negative!");
        }
    }

    public void set(String name, PMatrix2D mat) {
        float[] matv = new float[]{mat.m00, mat.m01, mat.m10, mat.m11};
        this.setUniformImpl(name, 16, matv);
    }

    public void set(String name, PMatrix3D mat) {
        this.set(name, mat, false);
    }

    public void set(String name, PMatrix3D mat, boolean use3x3) {
        if (use3x3) {
            float[] matv = new float[]{mat.m00, mat.m01, mat.m02, mat.m10, mat.m11, mat.m12, mat.m20, mat.m21, mat.m22};
            this.setUniformImpl(name, 17, matv);
        } else {
            float[] matv = new float[]{mat.m00, mat.m01, mat.m02, mat.m03, mat.m10, mat.m11, mat.m12, mat.m13, mat.m20, mat.m21, mat.m22, mat.m23, mat.m30, mat.m31, mat.m32, mat.m33};
            this.setUniformImpl(name, 18, matv);
        }
    }

    protected int getAttributeLoc(String name) {
        this.init();
        return this.pgl.glGetAttribLocation(this.glProgram, name);
    }

    protected int getUniformLoc(String name) {
        this.init();
        return this.pgl.glGetUniformLocation(this.glProgram, name);
    }

    protected void setAttributeVBO(int loc, int vboId, int size, int type, boolean normalized, int stride, int offset) {
        if (-1 < loc) {
            this.pgl.glBindBuffer(34962, vboId);
            this.pgl.glVertexAttribPointer(loc, size, type, normalized, stride, offset);
        }
    }

    protected void setUniformValue(int loc, int x) {
        if (-1 < loc) {
            this.pgl.glUniform1i(loc, x);
        }
    }

    protected void setUniformValue(int loc, int x, int y) {
        if (-1 < loc) {
            this.pgl.glUniform2i(loc, x, y);
        }
    }

    protected void setUniformValue(int loc, int x, int y, int z) {
        if (-1 < loc) {
            this.pgl.glUniform3i(loc, x, y, z);
        }
    }

    protected void setUniformValue(int loc, int x, int y, int z, int w) {
        if (-1 < loc) {
            this.pgl.glUniform4i(loc, x, y, z, w);
        }
    }

    protected void setUniformValue(int loc, float x) {
        if (-1 < loc) {
            this.pgl.glUniform1f(loc, x);
        }
    }

    protected void setUniformValue(int loc, float x, float y) {
        if (-1 < loc) {
            this.pgl.glUniform2f(loc, x, y);
        }
    }

    protected void setUniformValue(int loc, float x, float y, float z) {
        if (-1 < loc) {
            this.pgl.glUniform3f(loc, x, y, z);
        }
    }

    protected void setUniformValue(int loc, float x, float y, float z, float w) {
        if (-1 < loc) {
            this.pgl.glUniform4f(loc, x, y, z, w);
        }
    }

    protected void setUniformVector(int loc, int[] vec, int ncoords) {
        if (-1 < loc) {
            if (ncoords == 1) {
                this.pgl.glUniform1iv(loc, vec.length, vec, 0);
            } else if (ncoords == 2) {
                this.pgl.glUniform2iv(loc, vec.length / 2, vec, 0);
            } else if (ncoords == 3) {
                this.pgl.glUniform3iv(loc, vec.length / 3, vec, 0);
            } else if (ncoords == 4) {
                this.pgl.glUniform3iv(loc, vec.length / 4, vec, 0);
            }
        }
    }

    protected void setUniformVector(int loc, float[] vec, int ncoords) {
        if (-1 < loc) {
            if (ncoords == 1) {
                this.pgl.glUniform1fv(loc, vec.length, vec, 0);
            } else if (ncoords == 2) {
                this.pgl.glUniform2fv(loc, vec.length / 2, vec, 0);
            } else if (ncoords == 3) {
                this.pgl.glUniform3fv(loc, vec.length / 3, vec, 0);
            } else if (ncoords == 4) {
                this.pgl.glUniform4fv(loc, vec.length / 4, vec, 0);
            }
        }
    }

    protected void setUniformMatrix(int loc, float[] mat) {
        if (-1 < loc) {
            if (mat.length == 4) {
                this.pgl.glUniformMatrix2fv(loc, 1, false, mat, 0);
            } else if (mat.length == 9) {
                this.pgl.glUniformMatrix3fv(loc, 1, false, mat, 0);
            } else if (mat.length == 16) {
                this.pgl.glUniformMatrix4fv(loc, 1, false, mat, 0);
            }
        }
    }

    protected void setUniformImpl(String name, int type, Object value) {
        int loc = this.getUniformLoc(name);
        if (-1 < loc) {
            if (this.uniformValues == null) {
                this.uniformValues = new HashMap();
            }
            this.uniformValues.put(loc, new UniformValue(type, value));
        } else {
            PGraphics.showWarning("The shader doesn't have the uniform " + name);
        }
    }

    protected void consumeUniforms() {
        if (this.uniformValues != null && this.uniformValues.size() > 0) {
            for (Integer loc : this.uniformValues.keySet()) {
                Object[] v;
                UniformValue val = this.uniformValues.get(loc);
                if (val.type == 0) {
                    v = (int[])val.value;
                    this.pgl.glUniform1i(loc, v[0]);
                    continue;
                }
                if (val.type == 1) {
                    v = (int[])val.value;
                    this.pgl.glUniform2i(loc, v[0], v[1]);
                    continue;
                }
                if (val.type == 2) {
                    v = (int[])val.value;
                    this.pgl.glUniform3i(loc, v[0], v[1], v[2]);
                    continue;
                }
                if (val.type == 3) {
                    v = (int[])val.value;
                    this.pgl.glUniform4i(loc, v[0], v[1], v[2], v[4]);
                    continue;
                }
                if (val.type == 4) {
                    v = (float[])val.value;
                    this.pgl.glUniform1f(loc, v[0]);
                    continue;
                }
                if (val.type == 5) {
                    v = (float[])val.value;
                    this.pgl.glUniform2f(loc, v[0], v[1]);
                    continue;
                }
                if (val.type == 6) {
                    v = (float[])val.value;
                    this.pgl.glUniform3f(loc, v[0], v[1], v[2]);
                    continue;
                }
                if (val.type == 7) {
                    v = (float[])val.value;
                    this.pgl.glUniform4f(loc, v[0], v[1], v[2], v[3]);
                    continue;
                }
                if (val.type == 8) {
                    v = (int[])val.value;
                    this.pgl.glUniform1iv(loc, v.length, (int[])v, 0);
                    continue;
                }
                if (val.type == 9) {
                    v = (int[])val.value;
                    this.pgl.glUniform2iv(loc, v.length / 2, (int[])v, 0);
                    continue;
                }
                if (val.type == 10) {
                    v = (int[])val.value;
                    this.pgl.glUniform3iv(loc, v.length / 3, (int[])v, 0);
                    continue;
                }
                if (val.type == 11) {
                    v = (int[])val.value;
                    this.pgl.glUniform4iv(loc, v.length / 4, (int[])v, 0);
                    continue;
                }
                if (val.type == 12) {
                    v = (float[])val.value;
                    this.pgl.glUniform1fv(loc, v.length, (float[])v, 0);
                    continue;
                }
                if (val.type == 13) {
                    v = (float[])val.value;
                    this.pgl.glUniform2fv(loc, v.length / 2, (float[])v, 0);
                    continue;
                }
                if (val.type == 14) {
                    v = (float[])val.value;
                    this.pgl.glUniform3fv(loc, v.length / 3, (float[])v, 0);
                    continue;
                }
                if (val.type == 15) {
                    v = (float[])val.value;
                    this.pgl.glUniform4fv(loc, v.length / 4, (float[])v, 0);
                    continue;
                }
                if (val.type == 16) {
                    v = (float[])val.value;
                    this.pgl.glUniformMatrix2fv(loc, 1, false, (float[])v, 0);
                    continue;
                }
                if (val.type == 17) {
                    v = (float[])val.value;
                    this.pgl.glUniformMatrix3fv(loc, 1, false, (float[])v, 0);
                    continue;
                }
                if (val.type != 18) continue;
                v = (float[])val.value;
                this.pgl.glUniformMatrix4fv(loc, 1, false, (float[])v, 0);
            }
            this.uniformValues.clear();
        }
    }

    protected void init() {
        if (this.glProgram == 0 || this.contextIsOutdated()) {
            this.context = this.pgl.getCurrentContext();
            this.glProgram = this.pgMain.createGLSLProgramObject(this.context.code());
            boolean hasVert = false;
            if (this.vertexFilename != null) {
                hasVert = this.loadVertexShader(this.vertexFilename);
            } else if (this.vertexURL != null) {
                hasVert = this.loadVertexShader(this.vertexURL);
            } else {
                PGraphics.showException("Vertex shader filenames and URLs are both null!");
            }
            boolean hasFrag = false;
            if (this.fragmentFilename != null) {
                hasFrag = this.loadFragmentShader(this.fragmentFilename);
            } else if (this.fragmentURL != null) {
                hasFrag = this.loadFragmentShader(this.fragmentURL);
            } else {
                PGraphics.showException("Fragment shader filenames and URLs are both null!");
            }
            boolean vertRes = true;
            if (hasVert) {
                vertRes = this.compileVertexShader();
            }
            boolean fragRes = true;
            if (hasFrag) {
                fragRes = this.compileFragmentShader();
            }
            if (vertRes && fragRes) {
                if (hasVert) {
                    this.pgl.glAttachShader(this.glProgram, this.glVertex);
                }
                if (hasFrag) {
                    this.pgl.glAttachShader(this.glProgram, this.glFragment);
                }
                this.pgl.glLinkProgram(this.glProgram);
                int[] linked = new int[1];
                this.pgl.glGetProgramiv(this.glProgram, 35714, linked, 0);
                if (linked[0] == 0) {
                    PGraphics.showException("Cannot link shader program:\n" + this.pgl.glGetProgramInfoLog(this.glProgram));
                }
                this.pgl.glValidateProgram(this.glProgram);
                int[] validated = new int[1];
                this.pgl.glGetProgramiv(this.glProgram, 35715, validated, 0);
                if (validated[0] == 0) {
                    PGraphics.showException("Cannot validate shader program:\n" + this.pgl.glGetProgramInfoLog(this.glProgram));
                }
            }
        }
    }

    protected boolean contextIsOutdated() {
        boolean outdated;
        boolean bl = outdated = !this.pgl.contextIsCurrent(this.context);
        if (outdated) {
            this.pgMain.removeGLSLProgramObject(this.glProgram, this.context.code());
            this.pgMain.removeGLSLVertShaderObject(this.glVertex, this.context.code());
            this.pgMain.removeGLSLFragShaderObject(this.glFragment, this.context.code());
            this.glProgram = 0;
            this.glVertex = 0;
            this.glFragment = 0;
        }
        return outdated;
    }

    protected boolean loadVertexShader(String filename) {
        this.vertexShaderSource = PApplet.join(this.parent.loadStrings(filename), "\n");
        return this.vertexShaderSource != null;
    }

    protected boolean loadVertexShader(URL url) {
        try {
            this.vertexShaderSource = PApplet.join(PApplet.loadStrings(url.openStream()), "\n");
            return this.vertexShaderSource != null;
        }
        catch (IOException e) {
            PGraphics.showException("Cannot load vertex shader " + url.getFile());
            return false;
        }
    }

    protected boolean loadFragmentShader(String filename) {
        this.fragmentShaderSource = PApplet.join(this.parent.loadStrings(filename), "\n");
        return this.fragmentShaderSource != null;
    }

    protected boolean loadFragmentShader(URL url) {
        try {
            this.fragmentShaderSource = PApplet.join(PApplet.loadStrings(url.openStream()), "\n");
            return this.fragmentShaderSource != null;
        }
        catch (IOException e) {
            PGraphics.showException("Cannot load fragment shader " + url.getFile());
            return false;
        }
    }

    protected boolean compileVertexShader() {
        this.glVertex = this.pgMain.createGLSLVertShaderObject(this.context.code());
        this.pgl.glShaderSource(this.glVertex, this.vertexShaderSource);
        this.pgl.glCompileShader(this.glVertex);
        int[] compiled = new int[1];
        this.pgl.glGetShaderiv(this.glVertex, 35713, compiled, 0);
        if (compiled[0] == 0) {
            PGraphics.showException("Cannot compile vertex shader:\n" + this.pgl.glGetShaderInfoLog(this.glVertex));
            return false;
        }
        return true;
    }

    protected boolean compileFragmentShader() {
        this.glFragment = this.pgMain.createGLSLFragShaderObject(this.context.code());
        this.pgl.glShaderSource(this.glFragment, this.fragmentShaderSource);
        this.pgl.glCompileShader(this.glFragment);
        int[] compiled = new int[1];
        this.pgl.glGetShaderiv(this.glFragment, 35713, compiled, 0);
        if (compiled[0] == 0) {
            PGraphics.showException("Cannot compile fragment shader:\n" + this.pgl.glGetShaderInfoLog(this.glFragment));
            return false;
        }
        return true;
    }

    protected void setRenderer(PGraphicsOpenGL pg) {
        this.pgCurrent = pg;
    }

    protected void loadAttributes() {
    }

    protected void loadUniforms() {
    }

    protected void release() {
        if (this.glVertex != 0) {
            this.pgMain.deleteGLSLVertShaderObject(this.glVertex, this.context.code());
            this.glVertex = 0;
        }
        if (this.glFragment != 0) {
            this.pgMain.deleteGLSLFragShaderObject(this.glFragment, this.context.code());
            this.glFragment = 0;
        }
        if (this.glProgram != 0) {
            this.pgMain.deleteGLSLProgramObject(this.glProgram, this.context.code());
            this.glProgram = 0;
        }
    }

    protected class UniformValue {
        static final int INT1 = 0;
        static final int INT2 = 1;
        static final int INT3 = 2;
        static final int INT4 = 3;
        static final int FLOAT1 = 4;
        static final int FLOAT2 = 5;
        static final int FLOAT3 = 6;
        static final int FLOAT4 = 7;
        static final int INT1VEC = 8;
        static final int INT2VEC = 9;
        static final int INT3VEC = 10;
        static final int INT4VEC = 11;
        static final int FLOAT1VEC = 12;
        static final int FLOAT2VEC = 13;
        static final int FLOAT3VEC = 14;
        static final int FLOAT4VEC = 15;
        static final int MAT2 = 16;
        static final int MAT3 = 17;
        static final int MAT4 = 18;
        int type;
        Object value;

        UniformValue(int type, Object value) {
            this.type = type;
            this.value = value;
        }
    }
}

