/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.net.AssetURLContext;
import com.jogamp.common.nio.Buffers;
import com.jogamp.common.os.AndroidVersion;
import com.jogamp.common.os.MachineDescription;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.PropertyAccess;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import jogamp.common.Debug;
import jogamp.common.os.android.StaticContext;

public class IOUtil {
    private static final boolean DEBUG = Debug.isPropertyDefined("jogamp.debug.IOUtil", true);
    public static final String java_io_tmpdir_propkey = "java.io.tmpdir";

    private IOUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyURLConn2File(URLConnection uRLConnection, File file) throws IOException {
        uRLConnection.connect();
        int n = 0;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        try {
            n = IOUtil.copyStream2File(bufferedInputStream, file, uRLConnection.getContentLength());
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyStream2File(InputStream inputStream, File file, int n) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            n = IOUtil.copyStream2Stream(inputStream, bufferedOutputStream, n);
        }
        finally {
            ((OutputStream)bufferedOutputStream).close();
        }
        return n;
    }

    public static int copyStream2Stream(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[Platform.getMachineDescription().pageSizeInBytes()];
        int n3 = 0;
        while ((n2 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n2);
            n3 += n2;
        }
        return n3;
    }

    public static byte[] copyStream2ByteArray(InputStream inputStream) throws IOException {
        byte[] byArray;
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        int n = 0;
        int n2 = inputStream.available();
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        do {
            if (n + n2 > byArray2.length) {
                byArray = new byte[n + n2];
                System.arraycopy(byArray2, 0, byArray, 0, n);
                byArray2 = byArray;
            }
            if ((n3 = inputStream.read(byArray2, n, n2)) < 0) continue;
            n += n3;
        } while ((n2 = inputStream.available()) > 0 && n3 >= 0);
        if (n != byArray2.length) {
            byArray = new byte[n];
            System.arraycopy(byArray2, 0, byArray, 0, n);
            byArray2 = byArray;
        }
        return byArray2;
    }

    public static ByteBuffer copyStream2ByteBuffer(InputStream inputStream) throws IOException {
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        int n = inputStream.available();
        MachineDescription machineDescription = Platform.getMachineDescription();
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(machineDescription.pageAlignedSize(n));
        byte[] byArray = new byte[machineDescription.pageSizeInBytes()];
        int n2 = Math.min(machineDescription.pageSizeInBytes(), n);
        int n3 = 0;
        do {
            if (n > byteBuffer.remaining()) {
                ByteBuffer byteBuffer2 = Buffers.newDirectByteBuffer(machineDescription.pageAlignedSize(byteBuffer.position() + n));
                byteBuffer2.put(byteBuffer);
                byteBuffer = byteBuffer2;
            }
            if ((n3 = inputStream.read(byArray, 0, n2)) >= 0) {
                byteBuffer.put(byArray, 0, n3);
            }
            n = inputStream.available();
            n2 = Math.min(machineDescription.pageSizeInBytes(), n);
        } while (n > 0 && n3 >= 0);
        byteBuffer.flip();
        return byteBuffer;
    }

    public static String slashify(String string, boolean bl, boolean bl2) {
        String string2 = string.replace('\\', '/');
        if (bl && !string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        if (bl2 && !string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        return string2;
    }

    public static URL toURL(File file) throws MalformedURLException {
        return file.toURI().toURL();
    }

    public static URL toURLSimple(File file) throws MalformedURLException {
        return new URL("file", "", IOUtil.slashify(file.getAbsolutePath(), true, file.isDirectory()));
    }

    public static URL toURLSimple(String string, String string2, boolean bl) throws MalformedURLException {
        return new URL(string, "", IOUtil.slashify(string2, true, bl));
    }

    public static String getFileSuffix(File file) {
        return IOUtil.getFileSuffix(file.getName());
    }

    public static String getFileSuffix(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return null;
        }
        return IOUtil.toLowerCase(string.substring(n + 1));
    }

    public static String getClassFileName(String string) throws IOException {
        return string.replace('.', '/') + ".class";
    }

    public static URL getClassURL(String string, ClassLoader classLoader) throws IOException {
        return classLoader.getResource(IOUtil.getClassFileName(string));
    }

    public static String getBasename(String string) {
        int n = (string = IOUtil.slashify(string, false, false)).lastIndexOf(47);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public static String getDirname(String string) {
        int n = (string = IOUtil.slashify(string, false, false)).lastIndexOf(47);
        if (n >= 0) {
            string = string.substring(0, n + 1);
        }
        return string;
    }

    private static String toLowerCase(String string) {
        if (string == null) {
            return null;
        }
        return string.toLowerCase();
    }

    public static URLConnection getResource(Class<?> clazz, String string) {
        if (null == string) {
            return null;
        }
        ClassLoader classLoader = null != clazz ? clazz.getClassLoader() : IOUtil.class.getClassLoader();
        URLConnection uRLConnection = null;
        if (null != clazz) {
            String string2 = clazz.getName().replace('.', '/');
            int n = string2.lastIndexOf(47);
            if (n >= 0) {
                String string3 = string2.substring(0, n + 1) + string;
                uRLConnection = IOUtil.getResource(string3, classLoader);
            }
            if (DEBUG) {
                System.err.println("IOUtil: found <" + string + "> within class package: " + (null != uRLConnection));
            }
        } else if (DEBUG) {
            System.err.println("IOUtil: null context");
        }
        if (null == uRLConnection) {
            uRLConnection = IOUtil.getResource(string, classLoader);
            if (DEBUG) {
                System.err.println("IOUtil: found <" + string + "> by classloader: " + (null != uRLConnection));
            }
        }
        return uRLConnection;
    }

    public static URLConnection getResource(String string, ClassLoader classLoader) {
        if (null == string) {
            return null;
        }
        if (DEBUG) {
            System.err.println("IOUtil: locating <" + string + ">, has cl: " + (null != classLoader));
        }
        if (string.startsWith("asset:")) {
            try {
                return AssetURLContext.createURL(string, classLoader).openConnection();
            }
            catch (IOException iOException) {
                if (DEBUG) {
                    System.err.println("IOUtil: Catched Exception:");
                    iOException.printStackTrace();
                }
                return null;
            }
        }
        try {
            return AssetURLContext.resolve(string, classLoader);
        }
        catch (IOException iOException) {
            if (DEBUG) {
                System.err.println("IOUtil: Catched Exception:");
                iOException.printStackTrace();
            }
            return null;
        }
    }

    public static String getRelativeOf(File file, String string) {
        if (null == string) {
            return null;
        }
        if (file != null) {
            while (string.startsWith("../")) {
                file = file.getParentFile();
                string = string.substring(3);
            }
            File file2 = new File(file, string);
            return IOUtil.slashify(file2.getPath(), false, false);
        }
        return null;
    }

    public static String getParentOf(String string) throws MalformedURLException {
        int n;
        int n2 = n = null != string ? string.length() : 0;
        if (n == 0) {
            throw new MalformedURLException("path is empty <" + string + ">");
        }
        int n3 = string.lastIndexOf("/");
        if (n3 < 0) {
            throw new MalformedURLException("path contains no '/' <" + string + ">");
        }
        if (n3 == 0) {
            throw new MalformedURLException("path has no parents <" + string + ">");
        }
        if (n3 < n - 1) {
            return string.substring(0, n3 + 1);
        }
        int n4 = string.lastIndexOf("!") + 1;
        int n5 = string.lastIndexOf("/", n3 - 1);
        if (n5 >= n4) {
            return string.substring(0, n5 + 1);
        }
        throw new MalformedURLException("parent of path contains no '/' <" + string + ">");
    }

    public static URL getRelativeOf(URL uRL, String string) throws MalformedURLException {
        String string2 = uRL.getProtocol();
        String string3 = uRL.getAuthority();
        String string4 = uRL.getPath();
        String string5 = uRL.getQuery();
        String string6 = uRL.getRef();
        if (!string4.endsWith("/")) {
            string4 = IOUtil.getParentOf(string4);
        }
        while (string.startsWith("../")) {
            string4 = IOUtil.getParentOf(string4);
            string = string.substring(3);
        }
        return IOUtil.compose(string2, string3, string4, string, string5, string6);
    }

    public static URL compose(String string, String string2, String string3, String string4, String string5, String string6) throws MalformedURLException {
        StringBuffer stringBuffer = new StringBuffer();
        if (null != string) {
            stringBuffer.append(string);
            stringBuffer.append(":");
        }
        if (null != string2) {
            stringBuffer.append("//");
            stringBuffer.append(string2);
        }
        if (null != string3) {
            stringBuffer.append(string3);
        }
        if (null != string4) {
            stringBuffer.append(string4);
        }
        if (null != string5) {
            stringBuffer.append("?");
            stringBuffer.append(string5);
        }
        if (null != string6) {
            stringBuffer.append("#");
            stringBuffer.append(string6);
        }
        return new URL(stringBuffer.toString());
    }

    public static URLConnection openURL(URL uRL) {
        return IOUtil.openURL(uRL, ".");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static URLConnection openURL(URL uRL, String string) {
        if (null != uRL) {
            try {
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.connect();
                if (!DEBUG) return uRLConnection;
                System.err.println("IOUtil: urlExists(" + uRL + ") [" + string + "] - true");
                return uRLConnection;
            }
            catch (IOException iOException) {
                if (!DEBUG) return null;
                System.err.println("IOUtil: urlExists(" + uRL + ") [" + string + "] - false - " + iOException.getClass().getSimpleName() + ": " + iOException.getMessage());
                iOException.printStackTrace();
                return null;
            }
        } else {
            if (!DEBUG) return null;
            System.err.println("IOUtil: no url - urlExists(null) [" + string + "]");
        }
        return null;
    }

    public static File createTempFile(String string, String string2, AccessControlContext accessControlContext) throws IllegalArgumentException, IOException, SecurityException {
        return File.createTempFile(string, string2, IOUtil.getTempRoot(accessControlContext));
    }

    public static File getTempRoot(AccessControlContext accessControlContext) throws SecurityException, RuntimeException {
        Object object;
        if (AndroidVersion.isAvailable && null != (object = StaticContext.getContext())) {
            File file = object.getDir("temp", 1);
            if (null == file || !file.isDirectory() || !file.canWrite()) {
                throw new RuntimeException("Not a writable directory: '" + file + "', retrieved Android static context");
            }
            if (DEBUG) {
                System.err.println("IOUtil.getTempRoot(Android): temp dir: " + file.getAbsolutePath());
            }
            return file;
        }
        object = PropertyAccess.getProperty(java_io_tmpdir_propkey, false, accessControlContext);
        if (null == object || 0 == ((String)object).length()) {
            throw new RuntimeException("Property 'java.io.tmpdir' value is empty: <" + (String)object + ">");
        }
        File file = new File((String)object);
        if (null == file || !file.isDirectory() || !file.canWrite()) {
            throw new RuntimeException("Not a writable directory: '" + file + "', retrieved by propery '" + java_io_tmpdir_propkey + "'");
        }
        if (DEBUG) {
            System.err.println("IOUtil.getTempRoot(isAndroid: " + AndroidVersion.isAvailable + "): temp dir: " + file.getAbsolutePath());
        }
        return file;
    }

    public static File getTempDir(String string, AccessControlContext accessControlContext) throws IOException, SecurityException {
        File file = IOUtil.getTempRoot(accessControlContext);
        for (int i = 0; i <= 999999; ++i) {
            String string2 = String.format("_%06d", i);
            File file2 = new File(file, string + string2);
            if (file2.isDirectory()) {
                if (!file2.canWrite()) continue;
                return file2;
            }
            file2.mkdir();
            if (!file2.isDirectory()) {
                throw new IOException("Cannot create temp base directory " + file2);
            }
            if (!file2.canWrite()) {
                throw new IOException("Cannot write to created temp base directory " + file2);
            }
            return file2;
        }
        throw new IOException("Could not create temp directory @ " + file.getAbsolutePath() + string + "_*");
    }

    public static void close(Closeable closeable, boolean bl) throws RuntimeException {
        block4: {
            if (null != closeable) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {
                    if (bl) {
                        throw new RuntimeException(iOException);
                    }
                    if (!DEBUG) break block4;
                    System.err.println("Catched Exception: ");
                    iOException.printStackTrace();
                }
            }
        }
    }
}

