/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util.cache;

import com.jogamp.common.os.NativeLibrary;
import com.jogamp.common.util.IOUtil;
import com.jogamp.common.util.JarUtil;
import com.jogamp.common.util.SecurityUtil;
import com.jogamp.common.util.cache.TempFileCache;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import jogamp.common.Debug;

public class TempJarCache {
    private static final boolean DEBUG = Debug.debug("TempJarCache");
    private static Map<String, String> nativeLibMap;
    private static Set<URL> nativeLibJars;
    private static Set<URL> classFileJars;
    private static Set<URL> resourceFileJars;
    private static TempFileCache tmpFileCache;
    private static boolean staticInitError;
    private static volatile boolean isInit;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static boolean initSingleton() {
        if (!isInit) {
            Class<TempJarCache> clazz = TempJarCache.class;
            // MONITORENTER : com.jogamp.common.util.cache.TempJarCache.class
            if (!isInit) {
                isInit = true;
                boolean bl = staticInitError = !TempFileCache.initSingleton();
                if (!staticInitError) {
                    tmpFileCache = new TempFileCache();
                    boolean bl2 = staticInitError = !tmpFileCache.isValid();
                }
                if (!staticInitError) {
                    nativeLibMap = new HashMap<String, String>();
                    nativeLibJars = new HashSet<URL>();
                    classFileJars = new HashSet<URL>();
                    resourceFileJars = new HashSet<URL>();
                }
            }
            // MONITOREXIT : clazz
        }
        if (staticInitError) return false;
        return true;
    }

    public static boolean isInitialized() {
        return isInit && !staticInitError;
    }

    static void checkInitialized() {
        if (!isInit) {
            throw new RuntimeException("initSingleton() has to be called first.");
        }
    }

    public static TempFileCache getTempFileCache() {
        TempJarCache.checkInitialized();
        return tmpFileCache;
    }

    public static boolean containsNativeLibs(URL uRL) throws IOException {
        TempJarCache.checkInitialized();
        if (null == uRL) {
            throw new IllegalArgumentException("jarURL is null");
        }
        return nativeLibJars.contains(uRL);
    }

    public static boolean containsClasses(URL uRL) throws IOException {
        TempJarCache.checkInitialized();
        if (null == uRL) {
            throw new IllegalArgumentException("jarURL is null");
        }
        return classFileJars.contains(uRL);
    }

    public static boolean containsResources(URL uRL) throws IOException {
        TempJarCache.checkInitialized();
        if (null == uRL) {
            throw new IllegalArgumentException("jarURL is null");
        }
        return resourceFileJars.contains(uRL);
    }

    public static final void addNativeLibs(Class<?> clazz, URL uRL, ClassLoader classLoader) throws IOException, SecurityException {
        if (!TempJarCache.containsNativeLibs(uRL)) {
            JarFile jarFile = JarUtil.getJarFile(uRL, classLoader);
            if (DEBUG) {
                System.err.println("TempJarCache: addNativeLibs: " + uRL + ": nativeJar " + jarFile.getName());
            }
            TempJarCache.validateCertificates(clazz, jarFile);
            JarUtil.extract(tmpFileCache.getTempDir(), nativeLibMap, jarFile, true, false, false);
            nativeLibJars.add(uRL);
        }
    }

    public static final void addClasses(Class<?> clazz, URL uRL, ClassLoader classLoader) throws IOException, SecurityException {
        if (!TempJarCache.containsClasses(uRL)) {
            JarFile jarFile = JarUtil.getJarFile(uRL, classLoader);
            if (DEBUG) {
                System.err.println("TempJarCache: addClasses: " + uRL + ": nativeJar " + jarFile.getName());
            }
            TempJarCache.validateCertificates(clazz, jarFile);
            JarUtil.extract(tmpFileCache.getTempDir(), null, jarFile, false, true, false);
            classFileJars.add(uRL);
        }
    }

    public static final void addResources(Class<?> clazz, URL uRL, ClassLoader classLoader) throws IOException, SecurityException {
        if (!TempJarCache.containsResources(uRL)) {
            JarFile jarFile = JarUtil.getJarFile(uRL, classLoader);
            if (DEBUG) {
                System.err.println("TempJarCache: addResources: " + uRL + ": nativeJar " + jarFile.getName());
            }
            TempJarCache.validateCertificates(clazz, jarFile);
            JarUtil.extract(tmpFileCache.getTempDir(), null, jarFile, false, false, true);
            resourceFileJars.add(uRL);
        }
    }

    public static final void addAll(Class<?> clazz, URL uRL, ClassLoader classLoader) throws IOException, SecurityException {
        TempJarCache.checkInitialized();
        if (null == uRL) {
            throw new IllegalArgumentException("jarURL is null");
        }
        if (!(nativeLibJars.contains(uRL) && classFileJars.contains(uRL) && resourceFileJars.contains(uRL))) {
            JarFile jarFile = JarUtil.getJarFile(uRL, classLoader);
            if (DEBUG) {
                System.err.println("TempJarCache: addAll: " + uRL + ": nativeJar " + jarFile.getName());
            }
            boolean bl = !nativeLibJars.contains(uRL);
            boolean bl2 = !classFileJars.contains(uRL);
            boolean bl3 = !resourceFileJars.contains(uRL);
            TempJarCache.validateCertificates(clazz, jarFile);
            JarUtil.extract(tmpFileCache.getTempDir(), nativeLibMap, jarFile, bl, bl2, bl3);
            if (bl) {
                nativeLibJars.add(uRL);
            }
            if (bl2) {
                classFileJars.add(uRL);
            }
            if (bl3) {
                resourceFileJars.add(uRL);
            }
        }
    }

    public static final String findLibrary(String string) {
        File file;
        TempJarCache.checkInitialized();
        String string2 = nativeLibMap.get(string);
        if (null == string2 && null != NativeLibrary.isValidNativeLibraryName(string, false) && (file = new File(tmpFileCache.getTempDir(), string)).exists()) {
            string2 = file.getAbsolutePath();
        }
        return string2;
    }

    public static final String findResource(String string) {
        TempJarCache.checkInitialized();
        File file = new File(tmpFileCache.getTempDir(), string);
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        return null;
    }

    public static final URL getResource(String string) throws MalformedURLException {
        TempJarCache.checkInitialized();
        File file = new File(tmpFileCache.getTempDir(), string);
        if (file.exists()) {
            return IOUtil.toURLSimple(file);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void bootstrapNativeLib(Class<?> clazz, String string, URL uRL, ClassLoader classLoader) throws IOException, SecurityException {
        TempJarCache.checkInitialized();
        if (!nativeLibJars.contains(uRL) && !nativeLibMap.containsKey(string)) {
            JarFile jarFile = JarUtil.getJarFile(uRL, classLoader);
            if (DEBUG) {
                System.err.println("TempJarCache: bootstrapNativeLib: " + uRL + ": nativeJar " + jarFile.getName() + " - libBaseName: " + string);
            }
            TempJarCache.validateCertificates(clazz, jarFile);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                String string2 = jarEntry.getName();
                if (string2.indexOf(47) != -1 || string2.indexOf(File.separatorChar) != -1 || string2.indexOf(string) < 0) continue;
                File file = new File(tmpFileCache.getTempDir(), string2);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(jarFile.getInputStream(jarEntry));
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                int n = 0;
                try {
                    int n2;
                    byte[] byArray = new byte[2048];
                    while ((n2 = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
                        ((OutputStream)bufferedOutputStream).write(byArray, 0, n2);
                        n += n2;
                    }
                }
                finally {
                    ((InputStream)bufferedInputStream).close();
                    ((OutputStream)bufferedOutputStream).close();
                }
                if (n <= 0) continue;
                nativeLibMap.put(string, file.getAbsolutePath());
                nativeLibJars.add(uRL);
            }
        }
    }

    private static void validateCertificates(Class<?> clazz, JarFile jarFile) throws IOException, SecurityException {
        if (null == clazz) {
            throw new IllegalArgumentException("certClass is null");
        }
        Certificate[] certificateArray = SecurityUtil.getCerts(clazz);
        if (null != certificateArray) {
            JarUtil.validateCertificates(certificateArray, jarFile);
        }
    }

    static {
        staticInitError = false;
        isInit = false;
    }
}

