/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util.locks;

import com.jogamp.common.util.locks.Lock;
import java.io.File;
import jogamp.common.util.locks.SingletonInstanceFileLock;
import jogamp.common.util.locks.SingletonInstanceServerSocket;

public abstract class SingletonInstance
implements Lock {
    protected static final boolean DEBUG = true;
    private final long poll_ms;
    private boolean locked = false;

    public static SingletonInstance createFileLock(long l, String string) {
        return new SingletonInstanceFileLock(l, string);
    }

    public static SingletonInstance createFileLock(long l, File file) {
        return new SingletonInstanceFileLock(l, file);
    }

    public static SingletonInstance createServerSocket(long l, int n) {
        return new SingletonInstanceServerSocket(l, n);
    }

    protected SingletonInstance(long l) {
        this.poll_ms = Math.max(10L, l);
    }

    public final long getPollPeriod() {
        return this.poll_ms;
    }

    public abstract String getName();

    public final String toString() {
        return this.getName();
    }

    @Override
    public synchronized void lock() throws RuntimeException {
        try {
            while (!this.tryLock(TIMEOUT)) {
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeException(runtimeException);
        }
    }

    @Override
    public synchronized boolean tryLock(long l) throws RuntimeException {
        if (this.locked) {
            return true;
        }
        int n = 0;
        try {
            do {
                this.locked = this.tryLockImpl();
                if (this.locked) {
                    System.err.println("SLOCK " + System.currentTimeMillis() + " +++ " + this.getName() + " - Locked ");
                    return true;
                }
                if (0 == n) {
                    System.err.println("SLOCK " + System.currentTimeMillis() + " ??? " + this.getName() + " - Wait for lock");
                }
                Thread.sleep(this.poll_ms);
                ++n;
            } while (0L < (l -= this.poll_ms));
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("SLOCK " + System.currentTimeMillis() + " EEE " + this.getName() + " - couldn't get lock", interruptedException);
        }
        return false;
    }

    protected abstract boolean tryLockImpl();

    @Override
    public void unlock() throws RuntimeException {
        if (this.locked) {
            this.locked = !this.unlockImpl();
            System.err.println("SLOCK " + System.currentTimeMillis() + " --- " + this.getName() + " - Unlock " + (this.locked ? "failed" : "ok"));
        }
    }

    protected abstract boolean unlockImpl();

    @Override
    public synchronized boolean isLocked() {
        return this.locked;
    }
}

