/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.opengl;

import com.jogamp.common.GlueGenVersion;
import com.jogamp.common.util.VersionUtil;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.NEWTEvent;
import com.jogamp.newt.event.NEWTEventConsumer;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.WindowUpdateEvent;
import com.jogamp.opengl.JoglVersion;
import java.io.PrintStream;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.CapabilitiesChooser;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.SurfaceUpdatedListener;
import javax.media.nativewindow.util.InsetsImmutable;
import javax.media.nativewindow.util.Point;
import javax.media.opengl.FPSCounter;
import javax.media.opengl.GL;
import javax.media.opengl.GLAnimatorControl;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import javax.media.opengl.GLRunnable;
import jogamp.newt.WindowImpl;
import jogamp.opengl.FPSCounterImpl;
import jogamp.opengl.GLDrawableHelper;

public class GLWindow
implements GLAutoDrawable,
Window,
NEWTEventConsumer,
FPSCounter {
    private final WindowImpl window;
    private GLContext sharedContext = null;
    private int additionalCtxCreationFlags = 0;
    private GLDrawableFactory factory;
    private GLDrawable drawable;
    private GLContext context;
    private GLDrawableHelper helper = new GLDrawableHelper();
    private boolean sendReshape = false;
    private boolean sendDestroy = false;
    private FPSCounterImpl fpsCounter = new FPSCounterImpl();
    private InitAction initAction = new InitAction();
    private DisplayAction displayAction = new DisplayAction();

    protected GLWindow(Window window) {
        this.resetFPSCounter();
        this.window = (WindowImpl)window;
        this.window.setHandleDestroyNotify(false);
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowRepaint(WindowUpdateEvent windowUpdateEvent) {
                if (!GLWindow.this.window.isWindowLockedByOtherThread() && !GLWindow.this.helper.isAnimatorAnimating()) {
                    GLWindow.this.display();
                }
            }

            @Override
            public void windowResized(WindowEvent windowEvent) {
                GLWindow.this.sendReshape = true;
                if (!GLWindow.this.window.isWindowLockedByOtherThread() && !GLWindow.this.helper.isAnimatorAnimating()) {
                    GLWindow.this.display();
                }
            }

            @Override
            public void windowDestroyNotify(WindowEvent windowEvent) {
                if (1 == GLWindow.this.getDefaultCloseOperation()) {
                    if (GLWindow.this.helper.isExternalAnimatorRunning()) {
                        GLAnimatorControl gLAnimatorControl = GLWindow.this.helper.getAnimator();
                        boolean bl = gLAnimatorControl.pause();
                        GLWindow.this.destroy();
                        if (bl) {
                            gLAnimatorControl.resume();
                        }
                    } else if (GLWindow.this.window.isWindowLockedByOtherThread()) {
                        GLWindow.this.sendDestroy = true;
                    } else {
                        GLWindow.this.destroy();
                    }
                }
            }
        });
        this.window.setLifecycleHook(new GLLifecycleHook());
    }

    public static GLWindow create(GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        return new GLWindow(NewtFactory.createWindow(gLCapabilitiesImmutable));
    }

    public static GLWindow create(Screen screen, GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        return new GLWindow(NewtFactory.createWindow(screen, (CapabilitiesImmutable)gLCapabilitiesImmutable));
    }

    public static GLWindow create(Window window) {
        return new GLWindow(window);
    }

    public static GLWindow create(NativeWindow nativeWindow, GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        return new GLWindow(NewtFactory.createWindow(nativeWindow, (CapabilitiesImmutable)gLCapabilitiesImmutable));
    }

    @Override
    public int getDefaultCloseOperation() {
        return this.window.getDefaultCloseOperation();
    }

    @Override
    public int setDefaultCloseOperation(int n) {
        return this.window.setDefaultCloseOperation(n);
    }

    @Override
    public CapabilitiesChooser setCapabilitiesChooser(CapabilitiesChooser capabilitiesChooser) {
        return this.window.setCapabilitiesChooser(capabilitiesChooser);
    }

    @Override
    public final CapabilitiesImmutable getChosenCapabilities() {
        if (this.drawable == null) {
            return this.window.getChosenCapabilities();
        }
        return this.drawable.getChosenGLCapabilities();
    }

    @Override
    public final CapabilitiesImmutable getRequestedCapabilities() {
        return this.window.getRequestedCapabilities();
    }

    @Override
    public final Window getDelegatedWindow() {
        return this.window.getDelegatedWindow();
    }

    @Override
    public final NativeWindow getParent() {
        return this.window.getParent();
    }

    @Override
    public final Screen getScreen() {
        return this.window.getScreen();
    }

    @Override
    public final void setTitle(String string) {
        this.window.setTitle(string);
    }

    @Override
    public final String getTitle() {
        return this.window.getTitle();
    }

    @Override
    public final boolean isPointerVisible() {
        return this.window.isPointerVisible();
    }

    @Override
    public final void setPointerVisible(boolean bl) {
        this.window.setPointerVisible(bl);
    }

    @Override
    public final boolean isPointerConfined() {
        return this.window.isPointerConfined();
    }

    @Override
    public final void confinePointer(boolean bl) {
        this.window.confinePointer(bl);
    }

    @Override
    public final void setUndecorated(boolean bl) {
        this.window.setUndecorated(bl);
    }

    @Override
    public final void warpPointer(int n, int n2) {
        this.window.warpPointer(n, n2);
    }

    @Override
    public final boolean isUndecorated() {
        return this.window.isUndecorated();
    }

    @Override
    public final void setAlwaysOnTop(boolean bl) {
        this.window.setAlwaysOnTop(bl);
    }

    @Override
    public final boolean isAlwaysOnTop() {
        return this.window.isAlwaysOnTop();
    }

    @Override
    public final void setFocusAction(Window.FocusRunnable focusRunnable) {
        this.window.setFocusAction(focusRunnable);
    }

    @Override
    public void setKeyboardFocusHandler(KeyListener keyListener) {
        this.window.setKeyboardFocusHandler(keyListener);
    }

    @Override
    public final void requestFocus() {
        this.window.requestFocus();
    }

    @Override
    public final void requestFocus(boolean bl) {
        this.window.requestFocus(bl);
    }

    @Override
    public boolean hasFocus() {
        return this.window.hasFocus();
    }

    @Override
    public final InsetsImmutable getInsets() {
        return this.window.getInsets();
    }

    @Override
    public final void setPosition(int n, int n2) {
        this.window.setPosition(n, n2);
    }

    @Override
    public void setTopLevelPosition(int n, int n2) {
        this.window.setTopLevelPosition(n, n2);
    }

    @Override
    public final boolean setFullscreen(boolean bl) {
        return this.window.setFullscreen(bl);
    }

    @Override
    public final boolean isFullscreen() {
        return this.window.isFullscreen();
    }

    @Override
    public final boolean isVisible() {
        return this.window.isVisible();
    }

    @Override
    public final String toString() {
        return "NEWT-GLWindow[ \n\tHelper: " + this.helper + ", \n\tDrawable: " + this.drawable + ", \n\tContext: " + this.context + ", \n\tWindow: " + this.window + "]";
    }

    @Override
    public final int reparentWindow(NativeWindow nativeWindow) {
        return this.window.reparentWindow(nativeWindow);
    }

    @Override
    public final int reparentWindow(NativeWindow nativeWindow, boolean bl) {
        return this.window.reparentWindow(nativeWindow, bl);
    }

    @Override
    public final boolean removeChild(NativeWindow nativeWindow) {
        return this.window.removeChild(nativeWindow);
    }

    @Override
    public final boolean addChild(NativeWindow nativeWindow) {
        return this.window.addChild(nativeWindow);
    }

    @Override
    public final void destroy() {
        this.window.destroy();
    }

    @Override
    public final void setVisible(boolean bl) {
        this.window.setVisible(bl);
    }

    @Override
    public final void setSize(int n, int n2) {
        this.window.setSize(n, n2);
    }

    @Override
    public void setTopLevelSize(int n, int n2) {
        this.window.setTopLevelSize(n, n2);
    }

    @Override
    public final boolean isNativeValid() {
        return this.window.isNativeValid();
    }

    @Override
    public Point getLocationOnScreen(Point point) {
        return this.window.getLocationOnScreen(point);
    }

    @Override
    public GLDrawableFactory getFactory() {
        return this.factory;
    }

    public void setSharedContext(GLContext gLContext) {
        this.sharedContext = gLContext;
    }

    @Override
    public void setContext(GLContext gLContext) {
        this.context = gLContext;
        if (null != this.context) {
            this.context.setContextCreationFlags(this.additionalCtxCreationFlags);
        }
    }

    @Override
    public GLContext getContext() {
        return this.context;
    }

    @Override
    public GL getGL() {
        if (this.context == null) {
            return null;
        }
        return this.context.getGL();
    }

    @Override
    public GL setGL(GL gL) {
        if (this.context != null) {
            this.context.setGL(gL);
            return gL;
        }
        return null;
    }

    @Override
    public void addGLEventListener(GLEventListener gLEventListener) {
        if (null != this.helper) {
            this.helper.addGLEventListener(gLEventListener);
        }
    }

    @Override
    public void addGLEventListener(int n, GLEventListener gLEventListener) {
        if (null != this.helper) {
            this.helper.addGLEventListener(n, gLEventListener);
        }
    }

    @Override
    public void removeGLEventListener(GLEventListener gLEventListener) {
        if (null != this.helper) {
            this.helper.removeGLEventListener(gLEventListener);
        }
    }

    @Override
    public void setAnimator(GLAnimatorControl gLAnimatorControl) {
        if (null != this.helper) {
            this.helper.setAnimator(gLAnimatorControl);
        }
    }

    @Override
    public GLAnimatorControl getAnimator() {
        if (null != this.helper) {
            return this.helper.getAnimator();
        }
        return null;
    }

    @Override
    public void invoke(boolean bl, GLRunnable gLRunnable) {
        if (null != this.helper) {
            this.helper.invoke(this, bl, gLRunnable);
        }
    }

    @Override
    public void display() {
        if (!this.isNativeValid() || !this.isVisible()) {
            return;
        }
        if (this.sendDestroy || this.window.hasDeviceChanged() && GLAutoDrawable.SCREEN_CHANGE_ACTION_ENABLED) {
            this.sendDestroy = false;
            this.destroy();
            return;
        }
        if (null == this.context && 0 < this.getWidth() * this.getHeight()) {
            this.setVisible(true);
        }
        if (null != this.context) {
            this.helper.invokeGL(this.drawable, this.context, this.displayAction, this.initAction);
        }
    }

    @Override
    public void setAutoSwapBufferMode(boolean bl) {
        if (null != this.helper) {
            this.helper.setAutoSwapBufferMode(bl);
        }
    }

    @Override
    public boolean getAutoSwapBufferMode() {
        if (null != this.helper) {
            return this.helper.getAutoSwapBufferMode();
        }
        return false;
    }

    public void setSkipContextReleaseThread(Thread thread) {
        if (null != this.helper) {
            this.helper.setSkipContextReleaseThread(thread);
        }
    }

    public Thread getSkipContextReleaseThread() {
        if (null != this.helper) {
            return this.helper.getSkipContextReleaseThread();
        }
        return null;
    }

    @Override
    public void swapBuffers() {
        if (this.drawable != null && this.context != null) {
            this.drawable.swapBuffers();
        }
    }

    @Override
    public void setContextCreationFlags(int n) {
        this.additionalCtxCreationFlags = n;
    }

    @Override
    public int getContextCreationFlags() {
        return this.additionalCtxCreationFlags;
    }

    @Override
    public final void setUpdateFPSFrames(int n, PrintStream printStream) {
        this.fpsCounter.setUpdateFPSFrames(n, printStream);
    }

    @Override
    public final void resetFPSCounter() {
        this.fpsCounter.resetFPSCounter();
    }

    @Override
    public final int getUpdateFPSFrames() {
        return this.fpsCounter.getUpdateFPSFrames();
    }

    @Override
    public final long getFPSStartTime() {
        return this.fpsCounter.getFPSStartTime();
    }

    @Override
    public final long getLastFPSUpdateTime() {
        return this.fpsCounter.getLastFPSUpdateTime();
    }

    @Override
    public final long getLastFPSPeriod() {
        return this.fpsCounter.getLastFPSPeriod();
    }

    @Override
    public final float getLastFPS() {
        return this.fpsCounter.getLastFPS();
    }

    @Override
    public final int getTotalFPSFrames() {
        return this.fpsCounter.getTotalFPSFrames();
    }

    @Override
    public final long getTotalFPSDuration() {
        return this.fpsCounter.getTotalFPSDuration();
    }

    @Override
    public final float getTotalFPS() {
        return this.fpsCounter.getTotalFPS();
    }

    @Override
    public final NativeSurface getNativeSurface() {
        return null != this.drawable ? this.drawable.getNativeSurface() : null;
    }

    @Override
    public final long getHandle() {
        return null != this.drawable ? this.drawable.getHandle() : 0L;
    }

    @Override
    public final int getX() {
        return this.window.getX();
    }

    @Override
    public final int getY() {
        return this.window.getY();
    }

    @Override
    public final int getWidth() {
        return this.window.getWidth();
    }

    @Override
    public final int getHeight() {
        return this.window.getHeight();
    }

    @Override
    public final GLContext createContext(GLContext gLContext) {
        return this.drawable.createContext(gLContext);
    }

    @Override
    public final void setRealized(boolean bl) {
    }

    @Override
    public final boolean isRealized() {
        return null != this.drawable ? this.drawable.isRealized() : false;
    }

    @Override
    public final GLCapabilitiesImmutable getChosenGLCapabilities() {
        if (this.drawable == null) {
            throw new GLException("No drawable yet");
        }
        return this.drawable.getChosenGLCapabilities();
    }

    @Override
    public final GLProfile getGLProfile() {
        if (this.drawable == null) {
            throw new GLException("No drawable yet");
        }
        return this.drawable.getGLProfile();
    }

    @Override
    public boolean consumeEvent(NEWTEvent nEWTEvent) {
        return this.window.consumeEvent(nEWTEvent);
    }

    @Override
    public final void windowRepaint(int n, int n2, int n3, int n4) {
        this.window.windowRepaint(n, n2, n3, n4);
    }

    @Override
    public final void enqueueEvent(boolean bl, NEWTEvent nEWTEvent) {
        this.window.enqueueEvent(bl, nEWTEvent);
    }

    @Override
    public final void runOnEDTIfAvail(boolean bl, Runnable runnable) {
        this.window.runOnEDTIfAvail(bl, runnable);
    }

    @Override
    public final void removeSurfaceUpdatedListener(SurfaceUpdatedListener surfaceUpdatedListener) {
        this.window.removeSurfaceUpdatedListener(surfaceUpdatedListener);
    }

    @Override
    public final void addSurfaceUpdatedListener(SurfaceUpdatedListener surfaceUpdatedListener) {
        this.window.addSurfaceUpdatedListener(surfaceUpdatedListener);
    }

    @Override
    public final void addSurfaceUpdatedListener(int n, SurfaceUpdatedListener surfaceUpdatedListener) throws IndexOutOfBoundsException {
        this.window.addSurfaceUpdatedListener(n, surfaceUpdatedListener);
    }

    @Override
    public void sendWindowEvent(int n) {
        this.window.sendWindowEvent(n);
    }

    @Override
    public final WindowListener getWindowListener(int n) {
        return this.window.getWindowListener(n);
    }

    @Override
    public final WindowListener[] getWindowListeners() {
        return this.window.getWindowListeners();
    }

    @Override
    public final void removeWindowListener(WindowListener windowListener) {
        this.window.removeWindowListener(windowListener);
    }

    @Override
    public final void addWindowListener(WindowListener windowListener) {
        this.window.addWindowListener(windowListener);
    }

    @Override
    public final void addWindowListener(int n, WindowListener windowListener) throws IndexOutOfBoundsException {
        this.window.addWindowListener(n, windowListener);
    }

    @Override
    public final void addKeyListener(KeyListener keyListener) {
        this.window.addKeyListener(keyListener);
    }

    @Override
    public final void addKeyListener(int n, KeyListener keyListener) {
        this.window.addKeyListener(n, keyListener);
    }

    @Override
    public final void removeKeyListener(KeyListener keyListener) {
        this.window.removeKeyListener(keyListener);
    }

    @Override
    public final KeyListener getKeyListener(int n) {
        return this.window.getKeyListener(n);
    }

    @Override
    public final KeyListener[] getKeyListeners() {
        return this.window.getKeyListeners();
    }

    @Override
    public final void addMouseListener(MouseListener mouseListener) {
        this.window.addMouseListener(mouseListener);
    }

    @Override
    public final void addMouseListener(int n, MouseListener mouseListener) {
        this.window.addMouseListener(n, mouseListener);
    }

    @Override
    public final void removeMouseListener(MouseListener mouseListener) {
        this.window.removeMouseListener(mouseListener);
    }

    @Override
    public final MouseListener getMouseListener(int n) {
        return this.window.getMouseListener(n);
    }

    @Override
    public final MouseListener[] getMouseListeners() {
        return this.window.getMouseListeners();
    }

    @Override
    public final int lockSurface() {
        return this.window.lockSurface();
    }

    @Override
    public final void unlockSurface() throws NativeWindowException {
        this.window.unlockSurface();
    }

    @Override
    public final boolean isSurfaceLockedByOtherThread() {
        return this.window.isSurfaceLockedByOtherThread();
    }

    @Override
    public final boolean isSurfaceLocked() {
        return this.window.isSurfaceLocked();
    }

    @Override
    public final Thread getSurfaceLockOwner() {
        return this.window.getSurfaceLockOwner();
    }

    @Override
    public final boolean surfaceSwap() {
        return this.window.surfaceSwap();
    }

    @Override
    public final long getWindowHandle() {
        return this.window.getWindowHandle();
    }

    @Override
    public final long getSurfaceHandle() {
        return this.window.getSurfaceHandle();
    }

    @Override
    public final AbstractGraphicsConfiguration getGraphicsConfiguration() {
        return this.window.getGraphicsConfiguration();
    }

    @Override
    public final long getDisplayHandle() {
        return this.window.getDisplayHandle();
    }

    @Override
    public final int getScreenIndex() {
        return this.window.getScreenIndex();
    }

    @Override
    public final void surfaceUpdated(Object object, NativeSurface nativeSurface, long l) {
        this.window.surfaceUpdated(object, nativeSurface, l);
    }

    public static void main(String[] stringArray) {
        System.err.println(VersionUtil.getPlatformInfo());
        System.err.println(GlueGenVersion.getInstance());
        System.err.println((Object)JoglVersion.getInstance());
        System.err.println(JoglVersion.getDefaultOpenGLInfo(null).toString());
        GLProfile gLProfile = GLProfile.getDefault();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        GLWindow gLWindow = GLWindow.create(gLCapabilities);
        gLWindow.setSize(128, 128);
        gLWindow.addGLEventListener(new GLEventListener(){

            @Override
            public void init(GLAutoDrawable gLAutoDrawable) {
                GL gL = gLAutoDrawable.getGL();
                System.err.println(JoglVersion.getGLInfo(gL, null));
                System.err.println("Requested: " + gLAutoDrawable.getNativeSurface().getGraphicsConfiguration().getRequestedCapabilities());
                System.err.println("Chosen   : " + gLAutoDrawable.getChosenGLCapabilities());
            }

            @Override
            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }

            @Override
            public void display(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }
        });
        gLWindow.setVisible(true);
        gLWindow.destroy();
    }

    private class DisplayAction
    implements Runnable {
        private DisplayAction() {
        }

        @Override
        public final void run() {
            if (GLWindow.this.sendReshape) {
                GLWindow.this.helper.reshape(GLWindow.this, 0, 0, GLWindow.this.getWidth(), GLWindow.this.getHeight());
                GLWindow.this.sendReshape = false;
            }
            GLWindow.this.helper.display(GLWindow.this);
            GLWindow.this.fpsCounter.tickFPS();
        }
    }

    private class InitAction
    implements Runnable {
        private InitAction() {
        }

        @Override
        public final void run() {
            GLWindow.this.helper.init(GLWindow.this);
            GLWindow.this.resetFPSCounter();
        }
    }

    protected class GLLifecycleHook
    implements WindowImpl.LifecycleHook {
        private GLAnimatorControl savedAnimator = null;

        protected GLLifecycleHook() {
        }

        @Override
        public synchronized void destroyActionPreLock() {
        }

        @Override
        public synchronized void destroyActionInLock() {
            if (Window.DEBUG_IMPLEMENTATION) {
                String string = "GLWindow.destroy() " + Thread.currentThread() + ", start";
                System.err.println(string);
            }
            if (GLWindow.this.window.isNativeValid() && null != GLWindow.this.drawable && GLWindow.this.drawable.isRealized()) {
                if (null != GLWindow.this.context && GLWindow.this.context.isCreated()) {
                    try {
                        GLWindow.this.helper.disposeGL(GLWindow.this, GLWindow.this.drawable, GLWindow.this.context, null);
                    }
                    catch (GLException gLException) {
                        gLException.printStackTrace();
                    }
                }
                GLWindow.this.drawable.setRealized(false);
            }
            GLWindow.this.context = null;
            GLWindow.this.drawable = null;
            if (Window.DEBUG_IMPLEMENTATION) {
                System.err.println("GLWindow.destroy() " + Thread.currentThread() + ", fin");
            }
        }

        @Override
        public synchronized void resetCounter() {
            if (Window.DEBUG_IMPLEMENTATION) {
                System.err.println("GLWindow.resetCounter() " + Thread.currentThread());
            }
            GLWindow.this.resetFPSCounter();
        }

        @Override
        public synchronized void setVisibleActionPost(boolean bl, boolean bl2) {
            long l;
            if (Window.DEBUG_IMPLEMENTATION) {
                l = System.nanoTime();
                System.err.println("GLWindow.setVisibleActionPost(" + bl + ", " + bl2 + ") " + Thread.currentThread() + ", start");
            } else {
                l = 0L;
            }
            if (null == GLWindow.this.context && bl && 0L != GLWindow.this.window.getWindowHandle() && 0 < GLWindow.this.getWidth() * GLWindow.this.getHeight()) {
                NativeWindow nativeWindow = GLWindow.this.window.getWrappedWindow() != null ? NativeWindowFactory.getNativeWindow(GLWindow.this.window.getWrappedWindow(), GLWindow.this.window.getPrivateGraphicsConfiguration()) : GLWindow.this.window;
                GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)nativeWindow.getGraphicsConfiguration().getChosenCapabilities();
                if (null == GLWindow.this.factory) {
                    GLWindow.this.factory = GLDrawableFactory.getFactory(gLCapabilitiesImmutable.getGLProfile());
                }
                if (null == GLWindow.this.drawable) {
                    GLWindow.this.drawable = GLWindow.this.factory.createGLDrawable(nativeWindow);
                }
                GLWindow.this.drawable.setRealized(true);
                GLWindow.this.context = GLWindow.this.drawable.createContext(GLWindow.this.sharedContext);
                GLWindow.this.context.setSynchronized(true);
                GLWindow.this.context.setContextCreationFlags(GLWindow.this.additionalCtxCreationFlags);
            }
            if (Window.DEBUG_IMPLEMENTATION) {
                System.err.println("GLWindow.setVisibleActionPost(" + bl + ", " + bl2 + ") " + Thread.currentThread() + ", fin: dt " + (double)(System.nanoTime() - l) / 1000000.0 + "ms");
            }
        }

        @Override
        public synchronized boolean pauseRenderingAction() {
            boolean bl = false;
            this.savedAnimator = GLWindow.this.getAnimator();
            if (null != this.savedAnimator) {
                bl = this.savedAnimator.pause();
            }
            return bl;
        }

        @Override
        public synchronized void resumeRenderingAction() {
            if (null != this.savedAnimator && this.savedAnimator.isPaused()) {
                this.savedAnimator.resume();
            }
        }
    }
}

