/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.DirectoryEntry;
import jogamp.graph.font.typecast.ot.table.MaxpTable;
import jogamp.graph.font.typecast.ot.table.Table;

public class HdmxTable
implements Table {
    private DirectoryEntry _de;
    private int _version;
    private short _numRecords;
    private int _sizeDeviceRecords;
    private DeviceRecord[] _records;

    protected HdmxTable(DirectoryEntry directoryEntry, DataInput dataInput, MaxpTable maxpTable) throws IOException {
        this._de = (DirectoryEntry)directoryEntry.clone();
        this._version = dataInput.readUnsignedShort();
        this._numRecords = dataInput.readShort();
        this._sizeDeviceRecords = dataInput.readInt();
        this._records = new DeviceRecord[this._numRecords];
        for (int i = 0; i < this._numRecords; ++i) {
            this._records[i] = new DeviceRecord(maxpTable.getNumGlyphs(), dataInput);
        }
    }

    public int getNumberOfRecords() {
        return this._numRecords;
    }

    public DeviceRecord getRecord(int n) {
        return this._records[n];
    }

    @Override
    public int getType() {
        return 1751412088;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("'hdmx' Table - Horizontal Device Metrics\n----------------------------------------\n");
        stringBuffer.append("Size = ").append(this._de.getLength()).append(" bytes\n").append("\t'hdmx' version:         ").append(this._version).append("\n").append("\t# device records:       ").append(this._numRecords).append("\n").append("\tRecord length:          ").append(this._sizeDeviceRecords).append("\n");
        for (int i = 0; i < this._numRecords; ++i) {
            stringBuffer.append("\tDevRec ").append(i).append(": ppem = ").append(this._records[i].getPixelSize()).append(", maxWid = ").append(this._records[i].getMaxWidth()).append("\n");
            for (int j = 0; j < this._records[i].getWidths().length; ++j) {
                stringBuffer.append("    ").append(j).append(".   ").append(this._records[i].getWidths()[j]).append("\n");
            }
            stringBuffer.append("\n\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public DirectoryEntry getDirectoryEntry() {
        return this._de;
    }

    public class DeviceRecord {
        private short _pixelSize;
        private short _maxWidth;
        private short[] _widths;

        protected DeviceRecord(int n, DataInput dataInput) throws IOException {
            this._pixelSize = dataInput.readByte();
            this._maxWidth = dataInput.readByte();
            this._widths = new short[n];
            for (int i = 0; i < n; ++i) {
                this._widths[i] = dataInput.readByte();
            }
        }

        public short getPixelSize() {
            return this._pixelSize;
        }

        public short getMaxWidth() {
            return this._maxWidth;
        }

        public short[] getWidths() {
            return this._widths;
        }

        public short getWidth(int n) {
            return this._widths[n];
        }
    }
}

