/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;

public class NameRecord {
    private short _platformId;
    private short _encodingId;
    private short _languageId;
    private short _nameId;
    private short _stringLength;
    private short _stringOffset;
    private String _record;

    protected NameRecord(DataInput dataInput) throws IOException {
        this._platformId = dataInput.readShort();
        this._encodingId = dataInput.readShort();
        this._languageId = dataInput.readShort();
        this._nameId = dataInput.readShort();
        this._stringLength = dataInput.readShort();
        this._stringOffset = dataInput.readShort();
    }

    public short getEncodingId() {
        return this._encodingId;
    }

    public short getLanguageId() {
        return this._languageId;
    }

    public short getNameId() {
        return this._nameId;
    }

    public short getPlatformId() {
        return this._platformId;
    }

    public StringBuilder getRecordString(StringBuilder stringBuilder) {
        stringBuilder.append(this._record);
        return stringBuilder;
    }

    protected void loadString(DataInput dataInput) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        dataInput.skipBytes(this._stringOffset);
        if (this._platformId == 0) {
            for (int i = 0; i < this._stringLength / 2; ++i) {
                stringBuffer.append(dataInput.readChar());
            }
        } else if (this._platformId == 1) {
            for (int i = 0; i < this._stringLength; ++i) {
                stringBuffer.append((char)dataInput.readByte());
            }
        } else if (this._platformId == 2) {
            for (int i = 0; i < this._stringLength; ++i) {
                stringBuffer.append((char)dataInput.readByte());
            }
        } else if (this._platformId == 3) {
            for (int i = 0; i < this._stringLength / 2; ++i) {
                char c = dataInput.readChar();
                stringBuffer.append(c);
            }
        }
        this._record = stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("             Platform ID:       ").append(this._platformId).append("\n             Specific ID:       ").append(this._encodingId).append("\n             Language ID:       ").append(this._languageId).append("\n             Name ID:           ").append(this._nameId).append("\n             Length:            ").append(this._stringLength).append("\n             Offset:            ").append(this._stringOffset).append("\n\n").append(this._record);
        return stringBuffer.toString();
    }
}

