/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.Fixed;
import jogamp.graph.font.typecast.ot.table.DirectoryEntry;
import jogamp.graph.font.typecast.ot.table.Table;

public class VheaTable
implements Table {
    private DirectoryEntry _de;
    private int _version;
    private short _ascent;
    private short _descent;
    private short _lineGap;
    private short _advanceHeightMax;
    private short _minTopSideBearing;
    private short _minBottomSideBearing;
    private short _yMaxExtent;
    private short _caretSlopeRise;
    private short _caretSlopeRun;
    private short _metricDataFormat;
    private int _numberOfLongVerMetrics;

    protected VheaTable(DirectoryEntry directoryEntry, DataInput dataInput) throws IOException {
        this._de = (DirectoryEntry)directoryEntry.clone();
        this._version = dataInput.readInt();
        this._ascent = dataInput.readShort();
        this._descent = dataInput.readShort();
        this._lineGap = dataInput.readShort();
        this._advanceHeightMax = dataInput.readShort();
        this._minTopSideBearing = dataInput.readShort();
        this._minBottomSideBearing = dataInput.readShort();
        this._yMaxExtent = dataInput.readShort();
        this._caretSlopeRise = dataInput.readShort();
        this._caretSlopeRun = dataInput.readShort();
        for (int i = 0; i < 5; ++i) {
            dataInput.readShort();
        }
        this._metricDataFormat = dataInput.readShort();
        this._numberOfLongVerMetrics = dataInput.readUnsignedShort();
    }

    public short getAdvanceHeightMax() {
        return this._advanceHeightMax;
    }

    public short getAscent() {
        return this._ascent;
    }

    public short getCaretSlopeRise() {
        return this._caretSlopeRise;
    }

    public short getCaretSlopeRun() {
        return this._caretSlopeRun;
    }

    public short getDescent() {
        return this._descent;
    }

    public short getLineGap() {
        return this._lineGap;
    }

    public short getMetricDataFormat() {
        return this._metricDataFormat;
    }

    public short getMinTopSideBearing() {
        return this._minTopSideBearing;
    }

    public short getMinBottomSideBearing() {
        return this._minBottomSideBearing;
    }

    public int getNumberOfLongVerMetrics() {
        return this._numberOfLongVerMetrics;
    }

    @Override
    public int getType() {
        return 1986553185;
    }

    public short getYMaxExtent() {
        return this._yMaxExtent;
    }

    public String toString() {
        return new StringBuffer().append("'vhea' Table - Vertical Header\n------------------------------").append("\n        'vhea' version:       ").append(Fixed.floatValue(this._version)).append("\n        xAscender:            ").append(this._ascent).append("\n        xDescender:           ").append(this._descent).append("\n        xLineGap:             ").append(this._lineGap).append("\n        advanceHeightMax:     ").append(this._advanceHeightMax).append("\n        minTopSideBearing:    ").append(this._minTopSideBearing).append("\n        minBottomSideBearing: ").append(this._minBottomSideBearing).append("\n        yMaxExtent:           ").append(this._yMaxExtent).append("\n        horizCaretSlopeNum:   ").append(this._caretSlopeRise).append("\n        horizCaretSlopeDenom: ").append(this._caretSlopeRun).append("\n        reserved0:            0").append("\n        reserved1:            0").append("\n        reserved2:            0").append("\n        reserved3:            0").append("\n        reserved4:            0").append("\n        metricDataFormat:     ").append(this._metricDataFormat).append("\n        numOf_LongVerMetrics: ").append(this._numberOfLongVerMetrics).toString();
    }

    @Override
    public DirectoryEntry getDirectoryEntry() {
        return this._de;
    }
}

