/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.macosx;

import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.SurfaceChangeable;
import javax.media.nativewindow.util.Insets;
import javax.media.nativewindow.util.InsetsImmutable;
import javax.media.nativewindow.util.Point;
import javax.media.nativewindow.util.PointImmutable;
import jogamp.newt.WindowImpl;
import jogamp.newt.driver.DriverClearFocus;
import jogamp.newt.driver.DriverUpdatePosition;
import jogamp.newt.driver.macosx.MacDisplay;
import jogamp.newt.driver.macosx.MacKeyUtil;

public class MacWindow
extends WindowImpl
implements SurfaceChangeable,
DriverClearFocus,
DriverUpdatePosition {
    private int keyDownModifiers = 0;
    private int keyDownCode = 0;
    private static final int NSBorderlessWindowMask = 0;
    private static final int NSTitledWindowMask = 1;
    private static final int NSClosableWindowMask = 2;
    private static final int NSMiniaturizableWindowMask = 4;
    private static final int NSResizableWindowMask = 8;
    private static final int NSBackingStoreRetained = 0;
    private static final int NSBackingStoreNonretained = 1;
    private static final int NSBackingStoreBuffered = 2;
    private volatile long surfaceHandle = 0L;
    private long sscSurfaceHandle = 0L;
    private boolean isOffscreenInstance = false;

    @Override
    protected void createNativeImpl() {
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = GraphicsConfigurationFactory.getFactory(this.getScreen().getDisplay().getGraphicsDevice()).chooseGraphicsConfiguration(this.capsRequested, this.capsRequested, this.capabilitiesChooser, this.getScreen().getGraphicsScreen());
        if (null == abstractGraphicsConfiguration) {
            throw new NativeWindowException("Error choosing GraphicsConfiguration creating window: " + this);
        }
        this.setGraphicsConfiguration(abstractGraphicsConfiguration);
        this.reconfigureWindowImpl(this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.getReconfigureFlags(16, true));
        if (0L == this.getWindowHandle()) {
            throw new NativeWindowException("Error creating window");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeNativeImpl() {
        try {
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("MacWindow.CloseAction " + Thread.currentThread().getName());
            }
            if (this.getWindowHandle() != 0L) {
                this.close0(this.getWindowHandle());
            }
        }
        catch (Throwable throwable) {
            if (DEBUG_IMPLEMENTATION) {
                Exception exception = new Exception("Warning: closeNative failed - " + Thread.currentThread().getName(), throwable);
                exception.printStackTrace();
            }
        }
        finally {
            this.setWindowHandle(0L);
            this.surfaceHandle = 0L;
            this.sscSurfaceHandle = 0L;
            this.isOffscreenInstance = false;
        }
    }

    @Override
    protected int lockSurfaceImpl() {
        if (!this.isOffscreenInstance) {
            return this.lockSurface0(this.getWindowHandle()) ? 3 : 1;
        }
        return 3;
    }

    @Override
    protected void unlockSurfaceImpl() {
        if (!this.isOffscreenInstance) {
            this.unlockSurface0(this.getWindowHandle());
        }
    }

    @Override
    public final long getSurfaceHandle() {
        return 0L != this.sscSurfaceHandle ? this.sscSurfaceHandle : this.surfaceHandle;
    }

    @Override
    public void setSurfaceHandle(long l) {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("MacWindow.setSurfaceHandle(): 0x" + Long.toHexString(l));
        }
        this.sscSurfaceHandle = l;
        if (this.isNativeValid() && 0L != this.sscSurfaceHandle) {
            this.orderOut0(0L != this.getParentWindowHandle() ? this.getParentWindowHandle() : this.getWindowHandle());
        }
    }

    @Override
    public void surfaceSizeChanged(int n, int n2) {
        this.sizeChanged(false, n, n2, false);
    }

    @Override
    protected void setTitleImpl(String string) {
        this.setTitle0(this.getWindowHandle(), string);
    }

    @Override
    protected void requestFocusImpl(boolean bl) {
        if (!this.isOffscreenInstance) {
            this.requestFocus0(this.getWindowHandle(), bl);
        } else {
            this.focusChanged(false, true);
        }
    }

    @Override
    public final void clearFocus() {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("MacWindow: clearFocus() - requestFocusParent, isOffscreenInstance " + this.isOffscreenInstance);
        }
        if (!this.isOffscreenInstance) {
            this.requestFocusParent0(this.getWindowHandle());
        } else {
            this.focusChanged(false, false);
        }
    }

    @Override
    public void updatePosition() {
        Point point = this.getTopLevelLocationOnScreen(this.getX(), this.getY());
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("MacWindow: updatePosition() - isOffscreenInstance " + this.isOffscreenInstance + ", new abs pos: pS " + point);
        }
        if (!this.isOffscreenInstance) {
            this.setFrameTopLeftPoint0(this.getParentWindowHandle(), this.getWindowHandle(), point.getX(), point.getY());
        }
        super.positionChanged(true, this.getX(), this.getY());
    }

    @Override
    protected boolean reconfigureWindowImpl(int n, int n2, int n3, int n4, int n5) {
        Point point = this.getTopLevelLocationOnScreen(n, n2);
        boolean bl = this.isOffscreenInstance = 0L != this.sscSurfaceHandle || MacWindow.isOffscreenInstance(this, this.getParent());
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("MacWindow reconfig: " + n + "/" + n2 + " -> " + point + " - " + n3 + "x" + n4 + ", offscreenInstance " + this.isOffscreenInstance + ", " + MacWindow.getReconfigureFlagsAsString(null, n5));
        }
        if (0 != (0x10 & n5) && 0 == (0x1000 & n5)) {
            if (!this.isOffscreenInstance) {
                this.orderOut0(this.getWindowHandle());
            }
            this.visibleChanged(true, false);
        }
        if (0L == this.getWindowHandle() && 0 != (0x1000 & n5) || 0 != (2 & n5) || 0 != (1 & n5) || 0 != (4 & n5)) {
            this.createWindow(this.isOffscreenInstance, 0L != this.getWindowHandle(), point, n3, n4, 0 != (0x400 & n5));
            if (this.isVisible()) {
                n5 |= 0x10;
            }
        }
        if (n >= 0 && n2 >= 0) {
            if (!this.isOffscreenInstance) {
                this.setFrameTopLeftPoint0(this.getParentWindowHandle(), this.getWindowHandle(), point.getX(), point.getY());
            }
            super.positionChanged(true, n, n2);
        }
        if (n3 > 0 && n4 > 0) {
            if (!this.isOffscreenInstance) {
                this.setContentSize0(this.getWindowHandle(), n3, n4);
            }
            this.sizeChanged(true, n3, n4, false);
        }
        if (0 != (0x10 & n5) && 0 != (0x1000 & n5)) {
            if (!this.isOffscreenInstance) {
                this.orderFront0(this.getWindowHandle());
            }
            this.visibleChanged(true, true);
        }
        if (!this.isOffscreenInstance) {
            this.setAlwaysOnTop0(this.getWindowHandle(), 0 != (0x800 & n5));
        }
        return true;
    }

    @Override
    protected Point getLocationOnScreenImpl(int n, int n2) {
        Point point = new Point(n, n2);
        point.setX(Math.max(point.getX(), 0));
        point.setY(Math.max(point.getY(), 0));
        NativeWindow nativeWindow = this.getParent();
        if (null != nativeWindow && 0L != nativeWindow.getWindowHandle()) {
            point.translate(nativeWindow.getLocationOnScreen(null));
        }
        return point;
    }

    private Point getTopLevelLocationOnScreen(int n, int n2) {
        InsetsImmutable insetsImmutable = this.getInsets();
        return this.getLocationOnScreenImpl(n -= insetsImmutable.getLeftWidth(), n2 -= insetsImmutable.getTopHeight());
    }

    @Override
    protected void updateInsetsImpl(Insets insets) {
    }

    @Override
    protected void sizeChanged(boolean bl, int n, int n2, boolean bl2) {
        if (this.getWidth() != n || this.getHeight() != n2) {
            Point point = this.getTopLevelLocationOnScreen(this.getX(), this.getY());
            this.setFrameTopLeftPoint0(this.getParentWindowHandle(), this.getWindowHandle(), point.getX(), point.getY());
        }
        super.sizeChanged(bl, n, n2, bl2);
    }

    @Override
    protected void positionChanged(boolean bl, int n, int n2) {
        if (this.getWindowHandle() != 0L) {
            Point point = new Point(n, n2);
            NativeWindow nativeWindow = this.getParent();
            if (null != nativeWindow) {
                point.translate(nativeWindow.getLocationOnScreen(null).scale(-1, -1));
            }
            super.positionChanged(bl, point.getX(), point.getY());
        }
    }

    @Override
    protected boolean setPointerVisibleImpl(boolean bl) {
        if (!this.isOffscreenInstance) {
            return MacWindow.setPointerVisible0(this.getWindowHandle(), this.hasFocus(), bl);
        }
        return false;
    }

    @Override
    protected boolean confinePointerImpl(boolean bl) {
        if (!this.isOffscreenInstance) {
            return MacWindow.confinePointer0(this.getWindowHandle(), bl);
        }
        return false;
    }

    @Override
    protected void warpPointerImpl(int n, int n2) {
        if (!this.isOffscreenInstance) {
            MacWindow.warpPointer0(this.getWindowHandle(), n, n2);
        }
    }

    @Override
    public void sendKeyEvent(int n, int n2, int n3, char n4) {
        int n5 = MacKeyUtil.validateKeyCode(n3, (char)n4);
        boolean bl = this.validateKeyEvent(n, n2, n3);
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("MacWindow.sendKeyEvent " + Thread.currentThread().getName() + " char: 0x" + Integer.toHexString(n4) + ", code 0x" + Integer.toHexString(n3) + " -> 0x" + Integer.toHexString(n5) + ", valid " + bl);
        }
        if (bl) {
            n4 = 302 == n ? n4 : 65535;
            super.sendKeyEvent(n, n2, n5, (char)n4);
        }
    }

    @Override
    public void enqueueKeyEvent(boolean bl, int n, int n2, int n3, char n4) {
        int n5 = MacKeyUtil.validateKeyCode(n3, (char)n4);
        boolean bl2 = this.validateKeyEvent(n, n2, n3);
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("MacWindow.enqueueKeyEvent " + Thread.currentThread().getName() + " char: 0x" + Integer.toHexString(n4) + ", code 0x" + Integer.toHexString(n3) + " -> 0x" + Integer.toHexString(n5) + ", valid " + bl2);
        }
        if (bl2) {
            n4 = 302 == n ? n4 : 65535;
            super.enqueueKeyEvent(bl, n, n2, n5, (char)n4);
        }
    }

    private boolean validateKeyEvent(int n, int n2, int n3) {
        switch (n) {
            case 300: {
                this.keyDownModifiers = n2;
                this.keyDownCode = n3;
                return true;
            }
            case 301: {
                return this.keyDownModifiers == n2 && this.keyDownCode == n3;
            }
            case 302: {
                boolean bl = this.keyDownModifiers == n2 && this.keyDownCode == n3;
                this.keyDownModifiers = 0;
                this.keyDownCode = 0;
                return bl;
            }
        }
        throw new NativeWindowException("Unexpected key event type " + n);
    }

    private void createWindow(boolean bl, boolean bl2, PointImmutable pointImmutable, int n, int n2, boolean bl3) {
        if (0L != this.getWindowHandle() && !bl2) {
            return;
        }
        try {
            if (0L != this.getWindowHandle()) {
                this.surfaceHandle = this.changeContentView0(this.getParentWindowHandle(), this.getWindowHandle(), 0L);
                if (bl2 && 0L == this.surfaceHandle) {
                    throw new NativeWindowException("Internal Error - recreate, window but no view");
                }
                this.orderOut0(this.getWindowHandle());
                this.close0(this.getWindowHandle());
                this.setWindowHandle(0L);
            } else {
                this.surfaceHandle = 0L;
            }
            this.setWindowHandle(this.createWindow0(this.getParentWindowHandle(), pointImmutable.getX(), pointImmutable.getY(), n, n2, this.getGraphicsConfiguration().getChosenCapabilities().isBackgroundOpaque() && !bl, bl3, this.isUndecorated() || bl ? 0 : 15, 2, this.getScreen().getIndex(), this.surfaceHandle));
            if (this.getWindowHandle() == 0L) {
                throw new NativeWindowException("Could create native window " + Thread.currentThread().getName() + " " + this);
            }
            this.surfaceHandle = this.contentView0(this.getWindowHandle());
            if (bl) {
                this.orderOut0(0L != this.getParentWindowHandle() ? this.getParentWindowHandle() : this.getWindowHandle());
            } else {
                this.setTitle0(this.getWindowHandle(), this.getTitle());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected static native boolean initIDs0();

    private native long createWindow0(long var1, int var3, int var4, int var5, int var6, boolean var7, boolean var8, int var9, int var10, int var11, long var12);

    private native boolean lockSurface0(long var1);

    private native void unlockSurface0(long var1);

    private native void requestFocus0(long var1, boolean var3);

    private native void requestFocusParent0(long var1);

    private native void orderOut0(long var1);

    private native void orderFront0(long var1);

    private native void close0(long var1);

    private native void setTitle0(long var1, String var3);

    private native long contentView0(long var1);

    private native long changeContentView0(long var1, long var3, long var5);

    private native void setContentSize0(long var1, int var3, int var4);

    private native void setFrameTopLeftPoint0(long var1, long var3, int var5, int var6);

    private native void setAlwaysOnTop0(long var1, boolean var3);

    private static native Object getLocationOnScreen0(long var0, int var2, int var3);

    private static native boolean setPointerVisible0(long var0, boolean var2, boolean var3);

    private static native boolean confinePointer0(long var0, boolean var2);

    private static native void warpPointer0(long var0, int var2, int var3);

    static {
        MacDisplay.initSingleton();
    }
}

