/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import java.util.ArrayList;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;

public class GLGraphicsConfigurationUtil {
    public static final String NV_coverage_sample = "NV_coverage_sample";
    public static final int WINDOW_BIT = 1;
    public static final int BITMAP_BIT = 2;
    public static final int PBUFFER_BIT = 4;
    public static final int ALL_BITS = 7;

    public static final StringBuffer winAttributeBits2String(StringBuffer stringBuffer, int n) {
        if (null == stringBuffer) {
            stringBuffer = new StringBuffer();
        }
        boolean bl = false;
        if (0 != (1 & n)) {
            stringBuffer.append("WINDOW");
            bl = true;
        }
        if (0 != (2 & n)) {
            if (bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("BITMAP");
            bl = true;
        }
        if (0 != (4 & n)) {
            if (bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("PBUFFER");
        }
        return stringBuffer;
    }

    public static final int getWinAttributeBits(boolean bl, boolean bl2) {
        int n = 0;
        n = bl ? (n |= 1) : (!bl2 ? (n |= 2) : (n |= 4));
        return n;
    }

    public static final int getWinAttributeBits(GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        return GLGraphicsConfigurationUtil.getWinAttributeBits(gLCapabilitiesImmutable.isOnscreen(), gLCapabilitiesImmutable.isPBuffer());
    }

    public static final boolean addGLCapabilitiesPermutations(ArrayList arrayList, GLCapabilitiesImmutable gLCapabilitiesImmutable, int n) {
        GLCapabilities gLCapabilities;
        int n2 = arrayList.size();
        if (0 != (1 & n)) {
            gLCapabilities = (GLCapabilities)gLCapabilitiesImmutable.cloneMutable();
            gLCapabilities.setOnscreen(true);
            arrayList.add(gLCapabilities);
        }
        if (0 != (4 & n)) {
            gLCapabilities = (GLCapabilities)gLCapabilitiesImmutable.cloneMutable();
            gLCapabilities.setPBuffer(true);
            arrayList.add(gLCapabilities);
        }
        if (0 != (2 & n)) {
            gLCapabilities = (GLCapabilities)gLCapabilitiesImmutable.cloneMutable();
            gLCapabilities.setOnscreen(false);
            gLCapabilities.setPBuffer(false);
            arrayList.add(gLCapabilities);
        }
        return arrayList.size() > n2;
    }

    public static GLCapabilitiesImmutable fixGLCapabilities(GLCapabilitiesImmutable gLCapabilitiesImmutable, boolean bl) {
        if (!gLCapabilitiesImmutable.isOnscreen()) {
            return GLGraphicsConfigurationUtil.fixOffScreenGLCapabilities(gLCapabilitiesImmutable, bl);
        }
        return gLCapabilitiesImmutable;
    }

    public static GLCapabilitiesImmutable fixOffScreenGLCapabilities(GLCapabilitiesImmutable gLCapabilitiesImmutable, boolean bl) {
        if (gLCapabilitiesImmutable.getDoubleBuffered() || gLCapabilitiesImmutable.isOnscreen() || !bl && gLCapabilitiesImmutable.isPBuffer()) {
            GLCapabilities gLCapabilities = (GLCapabilities)gLCapabilitiesImmutable.cloneMutable();
            gLCapabilities.setDoubleBuffered(false);
            gLCapabilities.setOnscreen(false);
            if (gLCapabilities.isPBuffer() && !bl) {
                gLCapabilities.setPBuffer(false);
            }
            return gLCapabilities;
        }
        return gLCapabilitiesImmutable;
    }

    public static GLCapabilitiesImmutable fixGLPBufferGLCapabilities(GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        if (gLCapabilitiesImmutable.getDoubleBuffered() || gLCapabilitiesImmutable.isOnscreen() || !gLCapabilitiesImmutable.isPBuffer()) {
            GLCapabilities gLCapabilities = (GLCapabilities)gLCapabilitiesImmutable.cloneMutable();
            gLCapabilities.setDoubleBuffered(false);
            gLCapabilities.setOnscreen(false);
            gLCapabilities.setPBuffer(true);
            return gLCapabilities;
        }
        return gLCapabilitiesImmutable;
    }

    public static GLCapabilitiesImmutable fixOpaqueGLCapabilities(GLCapabilitiesImmutable gLCapabilitiesImmutable, boolean bl) {
        GLCapabilities gLCapabilities = null;
        if (gLCapabilitiesImmutable.isBackgroundOpaque() != bl) {
            gLCapabilities = (GLCapabilities)gLCapabilitiesImmutable.cloneMutable();
            gLCapabilities.setBackgroundOpaque(bl);
            return gLCapabilities;
        }
        return gLCapabilitiesImmutable;
    }
}

