/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.common.util.locks.LockFactory;
import com.jogamp.common.util.locks.RecursiveLock;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.NativeSurface;
import javax.media.opengl.GL;
import javax.media.opengl.GLAnimatorControl;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLPbuffer;
import javax.media.opengl.GLProfile;
import javax.media.opengl.GLRunnable;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableHelper;
import jogamp.opengl.GLDrawableImpl;

public class GLPbufferImpl
implements GLPbuffer {
    private GLDrawableImpl pbufferDrawable;
    private GLContextImpl context;
    private GLDrawableHelper drawableHelper = new GLDrawableHelper();
    private int floatMode;
    private int additionalCtxCreationFlags = 0;
    private RecursiveLock recurLock = LockFactory.createRecursiveLock();
    private InitAction initAction = new InitAction();
    private DisplayAction displayAction = new DisplayAction();
    private SwapBuffersAction swapBuffersAction = new SwapBuffersAction();

    public GLPbufferImpl(GLDrawableImpl gLDrawableImpl, GLContext gLContext) {
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)gLDrawableImpl.getNativeSurface().getGraphicsConfiguration().getChosenCapabilities();
        if (gLCapabilitiesImmutable.isOnscreen()) {
            if (gLCapabilitiesImmutable.isPBuffer()) {
                throw new IllegalArgumentException("Error: Given drawable is Onscreen and Pbuffer: " + gLDrawableImpl);
            }
            throw new IllegalArgumentException("Error: Given drawable is Onscreen: " + gLDrawableImpl);
        }
        if (!gLCapabilitiesImmutable.isPBuffer()) {
            throw new IllegalArgumentException("Error: Given drawable is not Pbuffer: " + gLDrawableImpl);
        }
        this.pbufferDrawable = gLDrawableImpl;
        this.context = (GLContextImpl)gLDrawableImpl.createContext(gLContext);
        this.context.setSynchronized(true);
    }

    @Override
    public GLContext createContext(GLContext gLContext) {
        return this.pbufferDrawable.createContext(gLContext);
    }

    @Override
    public void setRealized(boolean bl) {
    }

    @Override
    public boolean isRealized() {
        return true;
    }

    @Override
    public void destroy() {
        if (this.pbufferDrawable.isRealized()) {
            AbstractGraphicsDevice abstractGraphicsDevice = this.pbufferDrawable.getNativeSurface().getGraphicsConfiguration().getScreen().getDevice();
            if (null != this.context && this.context.isCreated()) {
                try {
                    this.drawableHelper.disposeGL(this, this.pbufferDrawable, this.context, null);
                }
                catch (GLException gLException) {
                    gLException.printStackTrace();
                }
                this.context = null;
            }
            this.pbufferDrawable.destroy();
            this.pbufferDrawable = null;
            if (null != abstractGraphicsDevice) {
                abstractGraphicsDevice.close();
            }
        }
    }

    public void setSize(int n, int n2) {
        throw new GLException("Not yet implemented");
    }

    @Override
    public NativeSurface getNativeSurface() {
        return this.pbufferDrawable.getNativeSurface();
    }

    @Override
    public long getHandle() {
        return this.pbufferDrawable.getHandle();
    }

    @Override
    public GLDrawableFactory getFactory() {
        return this.pbufferDrawable.getFactory();
    }

    @Override
    public int getWidth() {
        return this.pbufferDrawable.getWidth();
    }

    @Override
    public int getHeight() {
        return this.pbufferDrawable.getHeight();
    }

    @Override
    public void display() {
        this.invokeGL(this.displayAction);
    }

    public void repaint() {
        this.display();
    }

    @Override
    public void addGLEventListener(GLEventListener gLEventListener) {
        this.drawableHelper.addGLEventListener(gLEventListener);
    }

    @Override
    public void addGLEventListener(int n, GLEventListener gLEventListener) {
        this.drawableHelper.addGLEventListener(n, gLEventListener);
    }

    @Override
    public void removeGLEventListener(GLEventListener gLEventListener) {
        this.drawableHelper.removeGLEventListener(gLEventListener);
    }

    @Override
    public void setAnimator(GLAnimatorControl gLAnimatorControl) {
        this.drawableHelper.setAnimator(gLAnimatorControl);
    }

    @Override
    public GLAnimatorControl getAnimator() {
        return this.drawableHelper.getAnimator();
    }

    @Override
    public void invoke(boolean bl, GLRunnable gLRunnable) {
        this.drawableHelper.invoke(this, bl, gLRunnable);
    }

    @Override
    public void setContext(GLContext gLContext) {
        this.context = (GLContextImpl)gLContext;
        if (null != this.context) {
            this.context.setContextCreationFlags(this.additionalCtxCreationFlags);
        }
    }

    @Override
    public GLContext getContext() {
        return this.context;
    }

    public GLDrawable getDrawable() {
        return this.pbufferDrawable;
    }

    @Override
    public GL getGL() {
        return this.getContext().getGL();
    }

    @Override
    public GL setGL(GL gL) {
        return this.getContext().setGL(gL);
    }

    @Override
    public void setAutoSwapBufferMode(boolean bl) {
        this.drawableHelper.setAutoSwapBufferMode(bl);
    }

    @Override
    public boolean getAutoSwapBufferMode() {
        return this.drawableHelper.getAutoSwapBufferMode();
    }

    @Override
    public void swapBuffers() {
        this.invokeGL(this.swapBuffersAction);
    }

    @Override
    public void setContextCreationFlags(int n) {
        this.additionalCtxCreationFlags = n;
        if (null != this.context) {
            this.context.setContextCreationFlags(this.additionalCtxCreationFlags);
        }
    }

    @Override
    public int getContextCreationFlags() {
        return this.additionalCtxCreationFlags;
    }

    @Override
    public void bindTexture() {
        this.context.bindPbufferToTexture();
    }

    @Override
    public void releaseTexture() {
        this.context.releasePbufferFromTexture();
    }

    @Override
    public GLCapabilitiesImmutable getChosenGLCapabilities() {
        if (this.pbufferDrawable == null) {
            return null;
        }
        return this.pbufferDrawable.getChosenGLCapabilities();
    }

    public GLCapabilitiesImmutable getRequestedGLCapabilities() {
        if (this.pbufferDrawable == null) {
            return null;
        }
        return this.pbufferDrawable.getRequestedGLCapabilities();
    }

    @Override
    public GLProfile getGLProfile() {
        if (this.pbufferDrawable == null) {
            return null;
        }
        return this.pbufferDrawable.getGLProfile();
    }

    public int lockSurface() throws GLException {
        this.recurLock.lock();
        return 3;
    }

    public void unlockSurface() {
        this.recurLock.unlock();
    }

    public boolean isSurfaceLocked() {
        return this.recurLock.isLocked();
    }

    @Override
    public int getFloatingPointMode() {
        if (this.floatMode == 0) {
            throw new GLException("Pbuffer not initialized, or floating-point support not requested");
        }
        return this.floatMode;
    }

    private void invokeGL(Runnable runnable) {
        this.drawableHelper.invokeGL(this.pbufferDrawable, this.context, runnable, this.initAction);
    }

    class SwapBuffersAction
    implements Runnable {
        SwapBuffersAction() {
        }

        @Override
        public void run() {
            GLPbufferImpl.this.pbufferDrawable.swapBuffers();
        }
    }

    class DisplayAction
    implements Runnable {
        DisplayAction() {
        }

        @Override
        public void run() {
            GLPbufferImpl.this.drawableHelper.display(GLPbufferImpl.this);
        }
    }

    class InitAction
    implements Runnable {
        InitAction() {
        }

        @Override
        public void run() {
            GLPbufferImpl.this.floatMode = GLPbufferImpl.this.context.getFloatingPointMode();
            GLPbufferImpl.this.drawableHelper.init(GLPbufferImpl.this);
        }
    }
}

